/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.src.BiomeGenBoreal;
import net.minecraft.src.BiomeGenDesert;
import net.minecraft.src.BiomeGenForest;
import net.minecraft.src.BiomeGenHell;
import net.minecraft.src.BiomeGenOutback;
import net.minecraft.src.BiomeGenRainforest;
import net.minecraft.src.BiomeGenSeasonalForest;
import net.minecraft.src.BiomeGenShrublands;
import net.minecraft.src.BiomeGenSky;
import net.minecraft.src.BiomeGenSwamp;
import net.minecraft.src.BiomeGenTaiga;
import net.minecraft.src.Block;
import net.minecraft.src.EntityArmouredZombie;
import net.minecraft.src.EntityChicken;
import net.minecraft.src.EntityCow;
import net.minecraft.src.EntityCreeper;
import net.minecraft.src.EntityPig;
import net.minecraft.src.EntitySheep;
import net.minecraft.src.EntitySkeleton;
import net.minecraft.src.EntitySlime;
import net.minecraft.src.EntitySpider;
import net.minecraft.src.EntitySquid;
import net.minecraft.src.EntityZombie;
import net.minecraft.src.EnumCreatureType;
import net.minecraft.src.SpawnListEntry;
import net.minecraft.src.Weather;
import net.minecraft.src.WorldGenTreeShapeDefault;
import net.minecraft.src.WorldGenTreeShapeFancy;
import net.minecraft.src.WorldGenerator;

public class BiomeGenBase {
    public static final BiomeGenBase[] biomeList = new BiomeGenBase[16];
    public static final BiomeGenBase rainforest = new BiomeGenRainforest(0).setColor(588342).setBiomeName("Rainforest").setBlockedWeathers(new Weather[]{Weather.weatherSnow}).func_4124_a(2094168);
    public static final BiomeGenBase swampland = new BiomeGenSwamp(1).setColor(65459).setBiomeName("Swampland").func_4124_a(9154376);
    public static final BiomeGenBase seasonalForest = new BiomeGenSeasonalForest(2).setColor(10215459).setBiomeName("Seasonal Forest");
    public static final BiomeGenBase forest = new BiomeGenForest(3).setColor(353825).setBiomeName("Forest").func_4124_a(5159473);
    public static final BiomeGenBase grasslands = new BiomeGenDesert(4).setColor(14278691).setBiomeName("Grasslands").setBlockedWeathers(new Weather[]{Weather.weatherSnow});
    public static final BiomeGenBase outback = new BiomeGenOutback(5).setColor(14246435).setBiomeName("Outback").setBlockedWeathers(new Weather[]{Weather.weatherSnow});
    public static final BiomeGenBase shrubland = new BiomeGenShrublands(6).setColor(10595616).setBiomeName("Shrubland");
    public static final BiomeGenBase taiga = new BiomeGenTaiga(7).setColor(0xEDFFFE).setBiomeName("Taiga").setHasSurfaceSnow().func_4124_a(8107825);
    public static final BiomeGenBase borealForest = new BiomeGenBoreal(8).setColor(5097842).setBiomeName("Boreal Forest").func_4124_a(8107825);
    public static final BiomeGenBase desert = new BiomeGenDesert(9).setColor(0xFFFB00).setBiomeName("Desert").setBlockedWeathers(new Weather[]{Weather.weatherRain, Weather.weatherSnow, Weather.weatherStorm});
    public static final BiomeGenBase plains = new BiomeGenDesert(10).setColor(16776066).setBiomeName("Plains");
    public static final BiomeGenBase glacier = new BiomeGenDesert(11).setColor(16772499).setBiomeName("Glacier").setHasSurfaceSnow().func_4124_a(12899129);
    public static final BiomeGenBase tundra = new BiomeGenDesert(12).setColor(5762041).setBiomeName("Tundra").setHasSurfaceSnow().func_4124_a(12899129);
    public static final BiomeGenBase meadow = new BiomeGenBoreal(13).setColor(6986131).setBiomeName("Meadow");
    public static final BiomeGenBase hell = new BiomeGenHell(14).setColor(0xFF0000).setBiomeName("Hell").setBlockedWeathers(new Weather[]{Weather.weatherRain, Weather.weatherSnow, Weather.weatherStorm, Weather.weatherFog});
    public static final BiomeGenBase sky = new BiomeGenSky(15).setColor(0x8080FF).setBiomeName("Sky").setBlockedWeathers(new Weather[]{Weather.weatherRain, Weather.weatherSnow, Weather.weatherStorm, Weather.weatherFog});
    public String biomeName;
    public int id;
    public int color;
    public short topBlock;
    public short fillerBlock;
    public int field_6502_q;
    public Weather[] blockedWeathers = new Weather[0];
    protected List<SpawnListEntry> spawnableMonsterList;
    protected List<SpawnListEntry> spawnableCreatureList;
    protected List<SpawnListEntry> spawnableWaterCreatureList;
    private boolean hasSurfaceSnow = false;
    private static BiomeGenBase[] biomeLookupTable = new BiomeGenBase[4096];

    protected BiomeGenBase(int id2) {
        this.topBlock = (short)Block.grass.blockID;
        this.fillerBlock = (short)Block.dirt.blockID;
        this.field_6502_q = 5169201;
        this.spawnableMonsterList = new ArrayList<SpawnListEntry>();
        this.spawnableCreatureList = new ArrayList<SpawnListEntry>();
        this.spawnableWaterCreatureList = new ArrayList<SpawnListEntry>();
        this.spawnableMonsterList.add(new SpawnListEntry(EntitySpider.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityZombie.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityArmouredZombie.class, 2));
        this.spawnableMonsterList.add(new SpawnListEntry(EntitySkeleton.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityCreeper.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(EntitySlime.class, 10));
        this.spawnableCreatureList.add(new SpawnListEntry(EntitySheep.class, 102));
        this.spawnableCreatureList.add(new SpawnListEntry(EntityPig.class, 102));
        this.spawnableCreatureList.add(new SpawnListEntry(EntityChicken.class, 102));
        this.spawnableCreatureList.add(new SpawnListEntry(EntityCow.class, 102));
        this.spawnableWaterCreatureList.add(new SpawnListEntry(EntitySquid.class, 10));
        BiomeGenBase.biomeList[id2] = this;
        this.id = id2;
    }

    public static void generateBiomeLookup() {
        for (int i2 = 0; i2 < 64; ++i2) {
            for (int j2 = 0; j2 < 64; ++j2) {
                BiomeGenBase.biomeLookupTable[i2 + j2 * 64] = BiomeGenBase.getBiome((float)i2 / 63.0f, (float)j2 / 63.0f);
            }
        }
        BiomeGenBase.desert.topBlock = BiomeGenBase.desert.fillerBlock = (short)Block.sand.blockID;
        BiomeGenBase.outback.topBlock = (short)Block.dirtScorched.blockID;
        BiomeGenBase.outback.fillerBlock = (short)Block.dirtScorched.blockID;
        BiomeGenBase.glacier.topBlock = BiomeGenBase.glacier.fillerBlock = (short)Block.sand.blockID;
    }

    public WorldGenerator getRandomWorldGenForTrees(Random random) {
        if (random.nextInt(10) == 0) {
            return new WorldGenTreeShapeFancy(Block.leavesOak.blockID, Block.logOak.blockID);
        }
        return new WorldGenTreeShapeDefault(Block.leavesOak.blockID, Block.logOak.blockID, 4);
    }

    protected BiomeGenBase setBiomeName(String s2) {
        this.biomeName = s2;
        return this;
    }

    protected BiomeGenBase func_4124_a(int i2) {
        this.field_6502_q = i2;
        return this;
    }

    public static Color hex2Rgb(int colourHex) {
        int r2 = (colourHex & 0xFF0000) >> 16;
        int g2 = (colourHex & 0xFF00) >> 8;
        int b2 = colourHex & 0xFF;
        return new Color(r2, g2, b2);
    }

    protected BiomeGenBase setColor(int i2) {
        this.color = i2;
        return this;
    }

    public static BiomeGenBase getBiomeFromLookup(double d2, double d1) {
        int i2 = (int)(d2 * 63.0);
        int j2 = (int)(d1 * 63.0);
        return biomeLookupTable[i2 + j2 * 64];
    }

    public static BiomeGenBase getBiome(float temperature, float humidity) {
        humidity *= temperature;
        if (temperature < 0.2f) {
            if ((double)humidity < 0.05) {
                return tundra;
            }
            return taiga;
        }
        if (temperature < 0.3f) {
            if ((double)humidity < 0.05) {
                return tundra;
            }
            return borealForest;
        }
        if (humidity < 0.2f) {
            if (temperature < 0.35f) {
                return meadow;
            }
            if (temperature < 0.5f) {
                return shrubland;
            }
            if (temperature < 0.65f) {
                return grasslands;
            }
            if (humidity < 0.15f) {
                if (temperature > 0.95f) {
                    return desert;
                }
                if (temperature > 0.85f) {
                    return outback;
                }
            }
            return grasslands;
        }
        if (temperature < 0.5f) {
            return borealForest;
        }
        if (temperature < 0.97f) {
            if (humidity < 0.35f) {
                return shrubland;
            }
            if ((double)humidity > 0.85) {
                return rainforest;
            }
            if ((double)humidity > 0.5) {
                return forest;
            }
            return seasonalForest;
        }
        if (humidity < 0.45f) {
            return plains;
        }
        if (humidity < 0.6f) {
            return swampland;
        }
        return rainforest;
    }

    public int getSkyColorByTemp(float f2) {
        if ((f2 /= 3.0f) < -1.0f) {
            f2 = -1.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return Color.getHSBColor(0.6222222f - f2 * 0.05f, 0.5f + f2 * 0.1f, 1.0f).getRGB();
    }

    public List<SpawnListEntry> getSpawnableList(EnumCreatureType enumcreaturetype) {
        if (enumcreaturetype == EnumCreatureType.monster) {
            return this.spawnableMonsterList;
        }
        if (enumcreaturetype == EnumCreatureType.creature) {
            return this.spawnableCreatureList;
        }
        if (enumcreaturetype == EnumCreatureType.waterCreature) {
            return this.spawnableWaterCreatureList;
        }
        return null;
    }

    public boolean hasSurfaceSnow() {
        return this.hasSurfaceSnow;
    }

    protected BiomeGenBase setHasSurfaceSnow() {
        this.hasSurfaceSnow = true;
        return this;
    }

    protected BiomeGenBase setBlockedWeathers(Weather[] blocked) {
        this.blockedWeathers = blocked;
        return this;
    }

    static {
        BiomeGenBase.generateBiomeLookup();
    }
}

