/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityBoat;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.StatList;
import net.minecraft.src.World;

public class BlockAlgae
extends Block {
    @Override
    public void harvestBlock(World world, EntityPlayer entityplayer, int i2, int j2, int k2, int l2) {
        if (!world.isMultiplayerAndNotHost && entityplayer.getCurrentEquippedItem() != null && entityplayer.getCurrentEquippedItem().itemID == Item.toolShears.itemID) {
            entityplayer.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            world.dropItem(i2, j2, k2, new ItemStack(this.blockID, 1, 0));
        } else {
            super.harvestBlock(world, entityplayer, i2, j2, k2, l2);
        }
    }

    @Override
    public int idDropped(int i2, Random random) {
        return -1;
    }

    protected BlockAlgae(int i2, Material material) {
        super(i2, material);
        this.setBlockBounds(0.0f, -0.125f, 0.0f, 1.0f, 0.00625f, 1.0f);
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int i2, int j2, int k2, Entity entity) {
        if (entity instanceof EntityBoat) {
            world.playSoundEffectForPlayer(null, 2001, i2, j2, k2, this.blockID);
            world.setBlockWithNotify(i2, j2, k2, 0);
            this.onBlockDestroyedByPlayer(world, i2, j2, k2, 0);
            this.onBlockRemoval(world, i2, j2, k2);
        }
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i2, int j2, int k2) {
        int l2 = world.getBlockId(i2, j2, k2);
        return l2 == 0 && world.getBlockMaterial(i2, j2 - 1, k2) == Material.water;
    }

    @Override
    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        if (world.getBlockId(i2, j2 - 1, k2) != Block.fluidWaterStill.blockID) {
            world.setBlock(i2, j2, k2, 0);
        }
    }

    @Override
    public int getRenderType() {
        return 24;
    }

    @Override
    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.01f, 0.0f, 1.0f, 0.0125f, 1.0f);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        if (l2 == 1) {
            return true;
        }
        return super.shouldSideBeRendered(iblockaccess, i2, j2, k2, l2);
    }
}

