/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EnumSleepStatus;
import net.minecraft.src.Item;
import net.minecraft.src.Material;
import net.minecraft.src.ModelBed;
import net.minecraft.src.World;

public class BlockBed
extends Block {
    public static final int[][] headBlockToFootBlockMap = new int[][]{{0, 1}, {-1, 0}, {0, -1}, {1, 0}};

    public BlockBed(int i2) {
        super(i2, Material.wood);
        this.setBounds();
    }

    @Override
    public boolean blockActivated(World world, int x2, int y2, int z2, EntityPlayer player) {
        if (world.isMultiplayerAndNotHost) {
            return true;
        }
        int meta = world.getBlockMetadata(x2, y2, z2);
        if (!BlockBed.isBlockFootOfBed(meta)) {
            int dir = BlockBed.getDirectionFromMetadata(meta);
            if (world.getBlockId(x2 += headBlockToFootBlockMap[dir][0], y2, z2 += headBlockToFootBlockMap[dir][1]) != this.blockID) {
                return true;
            }
            meta = world.getBlockMetadata(x2, y2, z2);
        }
        if (!world.dimension.worldType.worldProvider.canRespawnHere()) {
            double d2 = (double)x2 + 0.5;
            double d1 = (double)y2 + 0.5;
            double d22 = (double)z2 + 0.5;
            world.setBlockWithNotify(x2, y2, z2, 0);
            int dir = BlockBed.getDirectionFromMetadata(meta);
            if (world.getBlockId(x2 += headBlockToFootBlockMap[dir][0], y2, z2 += headBlockToFootBlockMap[dir][1]) == this.blockID) {
                world.setBlockWithNotify(x2, y2, z2, 0);
                d2 = (d2 + (double)x2 + 0.5) / 2.0;
                d1 = (d1 + (double)y2 + 0.5) / 2.0;
                d22 = (d22 + (double)z2 + 0.5) / 2.0;
            }
            world.newExplosion(null, (float)x2 + 0.5f, (float)y2 + 0.5f, (float)z2 + 0.5f, 5.0f, true, false);
            return true;
        }
        if (BlockBed.isBedOccupied(meta)) {
            EntityPlayer player1 = null;
            for (EntityPlayer p2 : world.players) {
                if (!p2.isPlayerSleeping()) continue;
                ChunkCoordinates pos = p2.bedChunkCoordinates;
                if (pos.x != x2 || pos.y != y2 || pos.z != z2) continue;
                player1 = p2;
            }
            if (player1 == null) {
                BlockBed.setBedOccupied(world, x2, y2, z2, false);
            } else {
                player.addChatMessage("bed.occupied");
                return true;
            }
        }
        if (player.sleepInBedAt(x2, y2, z2) == EnumSleepStatus.OK) {
            BlockBed.setBedOccupied(world, x2, y2, z2, true);
            return true;
        }
        return true;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i2, int j2) {
        if (i2 == 0) {
            return BlockBed.texCoordToIndex(4, 0);
        }
        int k2 = BlockBed.getDirectionFromMetadata(j2);
        int l2 = ModelBed.bedDirection[k2][i2];
        if (BlockBed.isBlockFootOfBed(j2)) {
            if (l2 == 2) {
                return BlockBed.texCoordToIndex(8, 9);
            }
            if (l2 == 5 || l2 == 4) {
                return BlockBed.texCoordToIndex(7, 9);
            }
            return BlockBed.texCoordToIndex(7, 8);
        }
        if (l2 == 3) {
            return BlockBed.texCoordToIndex(5, 9);
        }
        if (l2 == 5 || l2 == 4) {
            return BlockBed.texCoordToIndex(6, 9);
        }
        return BlockBed.texCoordToIndex(6, 8);
    }

    @Override
    public int getRenderType() {
        return 14;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int i2, int j2, int k2) {
        this.setBounds();
    }

    @Override
    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        int i1 = world.getBlockMetadata(i2, j2, k2);
        int j1 = BlockBed.getDirectionFromMetadata(i1);
        if (BlockBed.isBlockFootOfBed(i1)) {
            if (world.getBlockId(i2 - headBlockToFootBlockMap[j1][0], j2, k2 - headBlockToFootBlockMap[j1][1]) != this.blockID) {
                world.setBlockWithNotify(i2, j2, k2, 0);
            }
        } else if (world.getBlockId(i2 + headBlockToFootBlockMap[j1][0], j2, k2 + headBlockToFootBlockMap[j1][1]) != this.blockID) {
            world.setBlockWithNotify(i2, j2, k2, 0);
        }
    }

    @Override
    public int idDropped(int i2, Random random) {
        return Item.bed.itemID;
    }

    private void setBounds() {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5625f, 1.0f);
    }

    public static int getDirectionFromMetadata(int i2) {
        return i2 & 3;
    }

    public static boolean isBlockFootOfBed(int i2) {
        return (i2 & 8) != 0;
    }

    public static boolean isBedOccupied(int i2) {
        return (i2 & 4) != 0;
    }

    public static void setBedOccupied(World world, int i2, int j2, int k2, boolean flag) {
        int l2 = world.getBlockMetadata(i2, j2, k2);
        l2 = flag ? (l2 |= 4) : (l2 &= 0xFFFFFFFB);
        world.setBlockMetadataWithNotify(i2, j2, k2, l2);
    }

    public static ChunkCoordinates getNearestEmptyChunkCoordinates(World world, int i2, int j2, int k2, int l2) {
        int i1 = world.getBlockMetadata(i2, j2, k2);
        int j1 = BlockBed.getDirectionFromMetadata(i1);
        for (int k1 = 0; k1 <= 1; ++k1) {
            int l1 = i2 - headBlockToFootBlockMap[j1][0] * k1 - 1;
            int i22 = k2 - headBlockToFootBlockMap[j1][1] * k1 - 1;
            int j22 = l1 + 2;
            int k22 = i22 + 2;
            for (int l22 = l1; l22 <= j22; ++l22) {
                for (int i3 = i22; i3 <= k22; ++i3) {
                    if (!world.isBlockNormalCube(l22, j2 - 1, i3) || !world.isAirBlock(l22, j2, i3) || !world.isAirBlock(l22, j2 + 1, i3)) continue;
                    if (l2 > 0) {
                        --l2;
                        continue;
                    }
                    return new ChunkCoordinates(l22, j2, i3);
                }
            }
        }
        return null;
    }

    @Override
    public void dropBlockAsItemWithChance(World world, int i2, int j2, int k2, int l2, float f2) {
        super.dropBlockAsItemWithChance(world, i2, j2, k2, l2, f2);
    }

    @Override
    public int getMobilityFlag() {
        return 1;
    }
}

