/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFurnace;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityBlastFurnace;
import net.minecraft.src.World;

public class BlockBlastFurnace
extends BlockFurnace {
    public BlockBlastFurnace(int i2, boolean flag) {
        super(i2, flag);
    }

    @Override
    public int idDropped(int i2, Random random) {
        return Block.furnaceBlastIdle.blockID;
    }

    @Override
    public boolean blockActivated(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        if (world.isMultiplayerAndNotHost) {
            return true;
        }
        TileEntityBlastFurnace tileentityblastfurnace = (TileEntityBlastFurnace)world.getBlockTileEntity(i2, j2, k2);
        entityplayer.displayGUIFurnace(tileentityblastfurnace);
        return true;
    }

    @Override
    public void randomDisplayTick(World world, int i2, int j2, int k2, Random random) {
        if (!this.isActive) {
            return;
        }
        int l2 = world.getBlockMetadata(i2, j2, k2);
        float f2 = (float)i2 + 0.5f;
        float f1 = (float)j2 + 0.0f + random.nextFloat() * 6.0f / 16.0f;
        float f22 = (float)k2 + 0.5f;
        float f3 = 0.52f;
        float f4 = random.nextFloat() * 0.6f - 0.3f;
        if (l2 == 4) {
            world.spawnParticle("smoke", f2 - f3, f1, f22 + f4, 0.0, 0.0, 0.0);
            world.spawnParticle("largeSmoke", f2 - f3, f1, f22 + f4, 0.0, 0.0, 0.0);
        } else if (l2 == 5) {
            world.spawnParticle("smoke", f2 + f3, f1, f22 + f4, 0.0, 0.0, 0.0);
            world.spawnParticle("largeSmoke", f2 + f3, f1, f22 + f4, 0.0, 0.0, 0.0);
        } else if (l2 == 2) {
            world.spawnParticle("smoke", f2 + f4, f1, f22 - f3, 0.0, 0.0, 0.0);
            world.spawnParticle("largeSmoke", f2 + f4, f1, f22 - f3, 0.0, 0.0, 0.0);
        } else if (l2 == 3) {
            world.spawnParticle("smoke", f2 + f4, f1, f22 + f3, 0.0, 0.0, 0.0);
            world.spawnParticle("largeSmoke", f2 + f4, f1, f22 + f3, 0.0, 0.0, 0.0);
        }
    }

    public static void updateFurnaceBlockState(boolean flag, World world, int i2, int j2, int k2) {
        int l2 = world.getBlockMetadata(i2, j2, k2);
        TileEntity tileentity = world.getBlockTileEntity(i2, j2, k2);
        keepFurnaceInventory = true;
        if (flag) {
            world.setBlockWithNotify(i2, j2, k2, Block.furnaceBlastActive.blockID);
        } else {
            world.setBlockWithNotify(i2, j2, k2, Block.furnaceBlastIdle.blockID);
        }
        keepFurnaceInventory = false;
        world.setBlockMetadataWithNotify(i2, j2, k2, l2);
        tileentity.validate();
        world.setBlockTileEntity(i2, j2, k2, tileentity);
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntityBlastFurnace();
    }
}

