/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockCake
extends Block {
    public BlockCake(int i2) {
        super(i2, Material.cake);
        this.setTickOnLoad(true);
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int i2, int j2, int k2) {
        int l2 = world.getBlockMetadata(i2, j2, k2);
        float f2 = 0.0625f;
        float f1 = (float)(1 + l2 * 2) / 16.0f;
        float f22 = 0.5f;
        this.setBlockBounds(f1, 0.0f, f2, 1.0f - f2, f22, 1.0f - f2);
    }

    @Override
    public void setBlockBoundsForItemRender() {
        float f2 = 0.0625f;
        float f1 = 0.5f;
        this.setBlockBounds(f2, 0.0f, f2, 1.0f - f2, f1, 1.0f - f2);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        int l2 = world.getBlockMetadata(i2, j2, k2);
        float f2 = 0.0625f;
        float f1 = (float)(1 + l2 * 2) / 16.0f;
        float f22 = 0.5f;
        return AxisAlignedBB.getBoundingBoxFromPool((float)i2 + f1, j2, (float)k2 + f2, (float)(i2 + 1) - f2, (float)j2 + f22 - f2, (float)(k2 + 1) - f2);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        int l2 = world.getBlockMetadata(i2, j2, k2);
        float f2 = 0.0625f;
        float f1 = (float)(1 + l2 * 2) / 16.0f;
        float f22 = 0.5f;
        return AxisAlignedBB.getBoundingBoxFromPool((float)i2 + f1, j2, (float)k2 + f2, (float)(i2 + 1) - f2, (float)j2 + f22, (float)(k2 + 1) - f2);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i2, int j2) {
        if (j2 > 0 && i2 == 4) {
            return BlockCake.texCoordToIndex(11, 7);
        }
        return this.atlasIndices[i2];
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean blockActivated(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        this.eatCakeSlice(world, i2, j2, k2, entityplayer);
        return true;
    }

    @Override
    public void onBlockClicked(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        this.eatCakeSlice(world, i2, j2, k2, entityplayer);
    }

    private void eatCakeSlice(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        if (entityplayer.health < 20) {
            entityplayer.heal(3);
            int l2 = world.getBlockMetadata(i2, j2, k2) + 1;
            if (l2 >= 6) {
                world.setBlockWithNotify(i2, j2, k2, 0);
            } else {
                world.setBlockMetadataWithNotify(i2, j2, k2, l2);
                world.markBlockAsNeedsUpdate(i2, j2, k2);
            }
        }
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i2, int j2, int k2) {
        if (!super.canPlaceBlockAt(world, i2, j2, k2)) {
            return false;
        }
        return this.canBlockStay(world, i2, j2, k2);
    }

    @Override
    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        if (!this.canBlockStay(world, i2, j2, k2)) {
            this.dropBlockAsItem(world, i2, j2, k2, world.getBlockMetadata(i2, j2, k2));
            world.setBlockWithNotify(i2, j2, k2, 0);
        }
    }

    @Override
    public boolean canBlockStay(World world, int i2, int j2, int k2) {
        return world.getBlockMaterial(i2, j2 - 1, k2).isSolid();
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return 0;
    }

    @Override
    public int idDropped(int i2, Random random) {
        return 0;
    }
}

