/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.Material;
import net.minecraft.src.Sides;
import net.minecraft.src.World;
import net.minecraft.src.helper.Direction;

public abstract class BlockContainerRotatable
extends BlockContainer {
    public BlockContainerRotatable(int i2, Material material) {
        super(i2, material);
    }

    public void setDefaultDirection(World world, int i2, int j2, int k2) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        int l2 = world.getBlockId(i2, j2, k2 - 1);
        int i1 = world.getBlockId(i2, j2, k2 + 1);
        int j1 = world.getBlockId(i2 - 1, j2, k2);
        int k1 = world.getBlockId(i2 + 1, j2, k2);
        int byte0 = 3;
        if (Block.opaqueCubeLookup[l2] && !Block.opaqueCubeLookup[i1]) {
            byte0 = 3;
        }
        if (Block.opaqueCubeLookup[i1] && !Block.opaqueCubeLookup[l2]) {
            byte0 = 2;
        }
        if (Block.opaqueCubeLookup[j1] && !Block.opaqueCubeLookup[k1]) {
            byte0 = 5;
        }
        if (Block.opaqueCubeLookup[k1] && !Block.opaqueCubeLookup[j1]) {
            byte0 = 4;
        }
        world.setBlockMetadataWithNotify(i2, j2, k2, byte0);
    }

    @Override
    public void onBlockPlaced(World world, int x2, int y2, int z2, Direction side, EntityLiving player, double sideHeight) {
        world.setBlockMetadataWithNotify(x2, y2, z2, player.getHorizontalPlacementDirection(side).meta());
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int side, int meta) {
        int index = Sides.orientationLookUp[6 * meta + side];
        return this.atlasIndices[index];
    }

    @Override
    public void onBlockAdded(World world, int i2, int j2, int k2) {
        super.onBlockAdded(world, i2, j2, k2);
        this.setDefaultDirection(world, i2, j2, k2);
    }
}

