/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.BlockRail;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityMinecart;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.World;

public class BlockDetectorRail
extends BlockRail {
    public BlockDetectorRail(int i2) {
        super(i2, true);
        this.setTickOnLoad(true);
    }

    @Override
    public int tickRate() {
        return 20;
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int i2, int j2, int k2, Entity entity) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        int l2 = world.getBlockMetadata(i2, j2, k2);
        if ((l2 & 8) != 0) {
            return;
        }
        this.setStateIfMinecartInteractsWithRail(world, i2, j2, k2, l2);
    }

    @Override
    public void updateTick(World world, int i2, int j2, int k2, Random random) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        int l2 = world.getBlockMetadata(i2, j2, k2);
        if ((l2 & 8) == 0) {
            return;
        }
        this.setStateIfMinecartInteractsWithRail(world, i2, j2, k2, l2);
    }

    @Override
    public boolean isPoweringTo(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        return (iblockaccess.getBlockMetadata(i2, j2, k2) & 8) != 0;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int i2, int j2, int k2, int l2) {
        if ((world.getBlockMetadata(i2, j2, k2) & 8) == 0) {
            return false;
        }
        return l2 == 1;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i2, int j2) {
        return this.atlasIndices[i2];
    }

    private void setStateIfMinecartInteractsWithRail(World world, int i2, int j2, int k2, int l2) {
        boolean flag = (l2 & 8) != 0;
        boolean flag1 = false;
        float f2 = 0.125f;
        List<Entity> list = world.getEntitiesWithinAABB(EntityMinecart.class, AxisAlignedBB.getBoundingBoxFromPool((float)i2 + f2, j2, (float)k2 + f2, (float)(i2 + 1) - f2, (double)j2 + 0.25, (float)(k2 + 1) - f2));
        if (list.size() > 0) {
            flag1 = true;
        }
        if (flag1 && !flag) {
            world.setBlockMetadataWithNotify(i2, j2, k2, l2 | 8);
            world.notifyBlocksOfNeighborChange(i2, j2, k2, this.blockID);
            world.notifyBlocksOfNeighborChange(i2, j2 - 1, k2, this.blockID);
            world.markBlocksDirty(i2, j2, k2, i2, j2, k2);
        }
        if (!flag1 && flag) {
            world.setBlockMetadataWithNotify(i2, j2, k2, l2 & 7);
            world.notifyBlocksOfNeighborChange(i2, j2, k2, this.blockID);
            world.notifyBlocksOfNeighborChange(i2, j2 - 1, k2, this.blockID);
            world.markBlocksDirty(i2, j2, k2, i2, j2, k2);
        }
        if (flag1) {
            world.scheduleBlockUpdate(i2, j2, k2, this.blockID, this.tickRate());
        }
    }
}

