/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockDirtPath
extends Block {
    public BlockDirtPath(int i2) {
        super(i2, Material.ground);
        this.setTickOnLoad(true);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.9375f, 1.0f);
        this.setLightOpacity(255);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        return AxisAlignedBB.getBoundingBoxFromPool(i2 + 0, j2 + 0, k2 + 0, i2 + 1, j2 + 1, k2 + 1);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        super.onNeighborBlockChange(world, i2, j2, k2, l2);
        Material material = world.getBlockMaterial(i2, j2 + 1, k2);
        int id2 = world.getBlockId(i2, j2 + 1, k2);
        if (material.isSolid() && id2 != Block.fencegatePlanksOak.blockID && id2 != Block.fencegatePlanksOakPainted.blockID && id2 != Block.signWallPlanksOak.blockID) {
            world.setBlockWithNotify(i2, j2, k2, Block.dirt.blockID);
        }
    }

    @Override
    public int idDropped(int i2, Random random) {
        return Block.dirt.idDropped(0, random);
    }
}

