/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainerRotatable;
import net.minecraft.src.EntityArrow;
import net.minecraft.src.EntityArrowGolden;
import net.minecraft.src.EntityCannonball;
import net.minecraft.src.EntityEgg;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPebble;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntitySnowball;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityDispenser;
import net.minecraft.src.World;

public class BlockDispenser
extends BlockContainerRotatable {
    private Random random = new Random();

    public BlockDispenser(int i2) {
        super(i2, Material.rock);
    }

    @Override
    public int tickRate() {
        return 4;
    }

    @Override
    public int idDropped(int i2, Random random) {
        return Block.dispenserCobbleStone.blockID;
    }

    @Override
    public void onBlockAdded(World world, int i2, int j2, int k2) {
        super.onBlockAdded(world, i2, j2, k2);
        this.setDispenserDefaultDirection(world, i2, j2, k2);
    }

    private void setDispenserDefaultDirection(World world, int i2, int j2, int k2) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        int l2 = world.getBlockId(i2, j2, k2 - 1);
        int i1 = world.getBlockId(i2, j2, k2 + 1);
        int j1 = world.getBlockId(i2 - 1, j2, k2);
        int k1 = world.getBlockId(i2 + 1, j2, k2);
        int byte0 = 3;
        if (Block.opaqueCubeLookup[l2] && !Block.opaqueCubeLookup[i1]) {
            byte0 = 3;
        }
        if (Block.opaqueCubeLookup[i1] && !Block.opaqueCubeLookup[l2]) {
            byte0 = 2;
        }
        if (Block.opaqueCubeLookup[j1] && !Block.opaqueCubeLookup[k1]) {
            byte0 = 5;
        }
        if (Block.opaqueCubeLookup[k1] && !Block.opaqueCubeLookup[j1]) {
            byte0 = 4;
        }
        world.setBlockMetadataWithNotify(i2, j2, k2, byte0);
    }

    @Override
    public boolean blockActivated(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        if (world.isMultiplayerAndNotHost) {
            return true;
        }
        TileEntityDispenser tileentitydispenser = (TileEntityDispenser)world.getBlockTileEntity(i2, j2, k2);
        entityplayer.displayGUIDispenser(tileentitydispenser);
        return true;
    }

    private void dispenseItem(World world, int i2, int j2, int k2, Random random) {
        int l2 = world.getBlockMetadata(i2, j2, k2);
        int i1 = 0;
        int j1 = 0;
        if (l2 == 3) {
            j1 = 1;
        } else if (l2 == 2) {
            j1 = -1;
        } else {
            i1 = l2 == 5 ? 1 : -1;
        }
        TileEntityDispenser tileentitydispenser = (TileEntityDispenser)world.getBlockTileEntity(i2, j2, k2);
        ItemStack itemstack = tileentitydispenser.getRandomStackFromInventory();
        double d2 = (double)i2 + (double)i1 * 0.6 + 0.5;
        double d1 = (double)j2 + 0.5;
        double d22 = (double)k2 + (double)j1 * 0.6 + 0.5;
        if (itemstack == null) {
            world.playSoundEffect(1001, i2, j2, k2, 0);
        } else {
            if (itemstack.itemID == Item.ammoArrow.itemID || itemstack.itemID == Item.ammoArrowGold.itemID) {
                EntityArrow entityarrow = itemstack.itemID == Item.ammoArrow.itemID ? new EntityArrow(world, d2, d1, d22, 0) : new EntityArrowGolden(world, d2, d1, d22);
                entityarrow.setArrowHeading(i1, 0.1f, j1, 1.1f, 6.0f);
                entityarrow.doesArrowBelongToPlayer = true;
                world.entityJoinedWorld(entityarrow);
                world.playSoundEffect(1002, i2, j2, k2, 0);
            } else if (itemstack.itemID == Item.ammoChargeExplosive.itemID) {
                EntityCannonball entitycannonball = new EntityCannonball(world, d2, d1, d22);
                entitycannonball.setCannonballHeading(i1, 0.1, j1, 1.1f, 6.0f);
                world.entityJoinedWorld(entitycannonball);
                world.playSoundEffect(1002, i2, j2, k2, 0);
            } else if (itemstack.itemID == Item.eggChicken.itemID) {
                EntityEgg entityegg = new EntityEgg(world, d2, d1, d22);
                entityegg.setEggHeading(i1, 0.1, j1, 1.1f, 6.0f);
                world.entityJoinedWorld(entityegg);
                world.playSoundEffect(1002, i2, j2, k2, 0);
            } else if (itemstack.itemID == Item.ammoSnowball.itemID) {
                EntitySnowball entitysnowball = new EntitySnowball(world, d2, d1, d22);
                entitysnowball.setSnowballHeading(i1, 0.1, j1, 1.1f, 6.0f);
                world.entityJoinedWorld(entitysnowball);
                world.playSoundEffect(1002, i2, j2, k2, 0);
            } else if (itemstack.itemID == Item.ammoPebble.itemID) {
                EntityPebble pebble = new EntityPebble(world, d2, d1, d22);
                pebble.setSnowballHeading(i1, 0.1, j1, 1.1f, 6.0f);
                world.entityJoinedWorld(pebble);
                world.playSoundEffect(1002, i2, j2, k2, 0);
            } else {
                EntityItem entityitem = new EntityItem(world, d2, d1 - 0.3, d22, itemstack);
                double d3 = random.nextDouble() * 0.1 + 0.2;
                entityitem.motionX = (double)i1 * d3;
                entityitem.motionY = 0.2f;
                entityitem.motionZ = (double)j1 * d3;
                entityitem.motionX += random.nextGaussian() * (double)0.0075f * 6.0;
                entityitem.motionY += random.nextGaussian() * (double)0.0075f * 6.0;
                entityitem.motionZ += random.nextGaussian() * (double)0.0075f * 6.0;
                world.entityJoinedWorld(entityitem);
                world.playSoundEffect(1000, i2, j2, k2, 0);
            }
            world.playSoundEffect(2000, i2, j2, k2, i1 + 1 + (j1 + 1) * 3);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        if (l2 > 0 && Block.blocksList[l2].canProvidePower()) {
            boolean flag;
            boolean bl2 = flag = world.isBlockIndirectlyGettingPowered(i2, j2, k2) || world.isBlockIndirectlyGettingPowered(i2, j2 + 1, k2);
            if (flag) {
                world.scheduleBlockUpdate(i2, j2, k2, this.blockID, this.tickRate());
            }
        }
    }

    @Override
    public void updateTick(World world, int i2, int j2, int k2, Random random) {
        if (world.isBlockIndirectlyGettingPowered(i2, j2, k2) || world.isBlockIndirectlyGettingPowered(i2, j2 + 1, k2)) {
            this.dispenseItem(world, i2, j2, k2, random);
        }
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntityDispenser();
    }

    @Override
    public void onBlockRemoval(World world, int i2, int j2, int k2) {
        if (world.getBlockTileEntity(i2, j2, k2) != null) {
            TileEntityDispenser tileentitydispenser = (TileEntityDispenser)world.getBlockTileEntity(i2, j2, k2);
            for (int l2 = 0; l2 < tileentitydispenser.getSizeInventory(); ++l2) {
                ItemStack itemstack = tileentitydispenser.getStackInSlot(l2);
                if (itemstack == null) continue;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                float f22 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int i1 = this.random.nextInt(21) + 10;
                    if (i1 > itemstack.stackSize) {
                        i1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= i1;
                    EntityItem entityitem = new EntityItem(world, (float)i2 + f2, (float)j2 + f1, (float)k2 + f22, new ItemStack(itemstack.itemID, i1, itemstack.getMetadata()));
                    float f3 = 0.05f;
                    entityitem.motionX = (float)this.random.nextGaussian() * f3;
                    entityitem.motionY = (float)this.random.nextGaussian() * f3 + 0.2f;
                    entityitem.motionZ = (float)this.random.nextGaussian() * f3;
                    world.entityJoinedWorld(entityitem);
                }
            }
        }
        super.onBlockRemoval(world, i2, j2, k2);
    }
}

