/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.Material;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public class BlockDoor
extends Block {
    public final boolean isTop;

    public BlockDoor(int i2, boolean isTop, Material material) {
        super(i2, material);
        this.isTop = isTop;
        float f2 = 0.5f;
        float f1 = 1.0f;
        this.setBlockBounds(0.5f - f2, 0.0f, 0.5f - f2, 0.5f + f2, f1, 0.5f + f2);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int side, int meta) {
        if (side == 0 || side == 1) {
            return this.atlasIndices[side];
        }
        int k2 = this.getState(meta);
        if ((k2 == 0 || k2 == 2) ^ side <= 3) {
            return this.atlasIndices[side];
        }
        int l2 = k2 / 2 + (side & 1 ^ k2);
        int i1 = this.atlasIndices[side];
        if (((l2 += (meta & 4) / 4) & 1) != 0) {
            i1 = -i1;
        }
        return i1;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 7;
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        this.setBlockBoundsBasedOnState(world, i2, j2, k2);
        return super.getSelectedBoundingBoxFromPool(world, i2, j2, k2);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        this.setBlockBoundsBasedOnState(world, i2, j2, k2);
        return super.getCollisionBoundingBoxFromPool(world, i2, j2, k2);
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int i2, int j2, int k2) {
        this.setDoorRotation(this.getState(world.getBlockMetadata(i2, j2, k2)));
    }

    public void setDoorRotation(int i2) {
        float f2 = 0.1875f;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f);
        if (i2 == 0) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f2);
        }
        if (i2 == 1) {
            this.setBlockBounds(1.0f - f2, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        if (i2 == 2) {
            this.setBlockBounds(0.0f, 0.0f, 1.0f - f2, 1.0f, 1.0f, 1.0f);
        }
        if (i2 == 3) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, f2, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean blockActivated(World world, int x2, int y2, int z2, EntityPlayer entityplayer) {
        if (this.blockMaterial == Material.iron) {
            return false;
        }
        int l2 = world.getBlockMetadata(x2, y2, z2);
        if (this.isTop) {
            if (Block.blocksList[world.getBlockId(x2, y2 - 1, z2)] instanceof BlockDoor) {
                Block.blocksList[world.getBlockId(x2, y2 - 1, z2)].blockActivated(world, x2, y2 - 1, z2, entityplayer);
            }
            return true;
        }
        if (Block.blocksList[world.getBlockId(x2, y2 + 1, z2)] instanceof BlockDoor) {
            world.setBlockMetadataWithNotify(x2, y2 + 1, z2, l2 ^ 4);
        }
        world.setBlockMetadataWithNotify(x2, y2, z2, l2 ^ 4);
        world.markBlocksDirty(x2, y2 - 1, z2, x2, y2, z2);
        world.playSoundEffectForPlayer(entityplayer, 1003, x2, y2, z2, 0);
        return true;
    }

    public void onPoweredBlockChange(World world, int x2, int y2, int z2, boolean isPowered) {
        boolean isOpen;
        int l2 = world.getBlockMetadata(x2, y2, z2);
        if ((l2 & 8) > 0) {
            boolean bl2 = isPowered = !isPowered;
        }
        if (this.isTop) {
            if (Block.blocksList[world.getBlockId(x2, y2 - 1, z2)] instanceof BlockDoor) {
                ((BlockDoor)Block.blocksList[world.getBlockId(x2, y2 - 1, z2)]).onPoweredBlockChange(world, x2, y2 - 1, z2, isPowered);
            }
            return;
        }
        boolean bl3 = isOpen = (world.getBlockMetadata(x2, y2, z2) & 4) > 0;
        if (isOpen == isPowered) {
            return;
        }
        if (Block.blocksList[world.getBlockId(x2, y2 + 1, z2)] instanceof BlockDoor) {
            world.setBlockMetadataWithNotify(x2, y2 + 1, z2, l2 ^ 4);
        }
        world.setBlockMetadataWithNotify(x2, y2, z2, l2 ^ 4);
        world.markBlocksDirty(x2, y2 - 1, z2, x2, y2, z2);
        world.playSoundEffectForPlayer(null, 1003, x2, y2, z2, 0);
    }

    @Override
    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        int i1 = world.getBlockMetadata(i2, j2, k2);
        if (this.isTop) {
            Block otherBlock = Block.blocksList[world.getBlockId(i2, j2 - 1, k2)];
            if (!(otherBlock instanceof BlockDoor)) {
                world.setBlockWithNotify(i2, j2, k2, 0);
            }
            if (l2 > 0 && Block.blocksList[l2].canProvidePower()) {
                otherBlock.onNeighborBlockChange(world, i2, j2 - 1, k2, l2);
            }
        } else {
            boolean flag = false;
            Block otherBlock = Block.blocksList[world.getBlockId(i2, j2 + 1, k2)];
            if (!(otherBlock instanceof BlockDoor)) {
                world.setBlockWithNotify(i2, j2, k2, 0);
                flag = true;
            }
            if (!world.canPlaceOnSurfaceOfBlock(i2, j2 - 1, k2)) {
                world.setBlockWithNotify(i2, j2, k2, 0);
                this.dropBlockAsItem(world, i2, j2, k2, i1);
                flag = true;
                if (otherBlock instanceof BlockDoor) {
                    world.setBlockWithNotify(i2, j2 + 1, k2, 0);
                }
            }
            if (flag) {
                if (!world.isMultiplayerAndNotHost) {
                    // empty if block
                }
            } else if (l2 > 0 && Block.blocksList[l2].canProvidePower()) {
                boolean flag1 = world.isBlockIndirectlyGettingPowered(i2, j2, k2) || world.isBlockIndirectlyGettingPowered(i2, j2 + 1, k2);
                this.onPoweredBlockChange(world, i2, j2, k2, flag1);
            }
        }
    }

    @Override
    public void randomDisplayTick(World world, int x2, int y2, int z2, Random random) {
        int myId = world.getBlockId(x2, y2, z2);
        int myMetadata = world.getBlockMetadata(x2, y2, z2);
        int upId = world.getBlockId(x2, y2 + 1, z2);
        if (myId == Block.doorPlanksOakBottom.blockID && upId == Block.doorPlanksOakBottom.blockID) {
            world.setBlockAndMetadata(x2, y2 + 1, z2, Block.doorPlanksOakTop.blockID, myMetadata);
        } else if (myId == Block.doorIronBottom.blockID && upId == Block.doorIronBottom.blockID) {
            world.setBlockAndMetadata(x2, y2 + 1, z2, Block.doorIronTop.blockID, myMetadata);
        }
    }

    @Override
    public int idDropped(int i2, Random random) {
        if (this.blockMaterial == Material.iron) {
            return Item.doorIron.itemID;
        }
        return Item.doorOak.itemID;
    }

    @Override
    public MovingObjectPosition collisionRayTrace(World world, int i2, int j2, int k2, Vec3D vec3d, Vec3D vec3d1) {
        this.setBlockBoundsBasedOnState(world, i2, j2, k2);
        return super.collisionRayTrace(world, i2, j2, k2, vec3d, vec3d1);
    }

    public int getState(int i2) {
        if ((i2 & 4) == 0) {
            return i2 - 1 & 3;
        }
        return i2 & 3;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i2, int j2, int k2) {
        if (j2 >= Minecraft.WORLD_HEIGHT_BLOCKS - 1) {
            return false;
        }
        return world.canPlaceOnSurfaceOfBlock(i2, j2 - 1, k2) && super.canPlaceBlockAt(world, i2, j2, k2) && super.canPlaceBlockAt(world, i2, j2 + 1, k2);
    }

    public static boolean isOpen(int i2) {
        return (i2 & 4) != 0;
    }

    @Override
    public int getMobilityFlag() {
        return 1;
    }
}

