/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockFence
extends Block {
    public BlockFence(int i2) {
        super(i2, Material.wood);
    }

    @Override
    public boolean canPlaceOnSurface() {
        return true;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        boolean connectXPos = this.canConnectTo(world, i2 + 1, j2, k2);
        boolean connectXNeg = this.canConnectTo(world, i2 - 1, j2, k2);
        boolean connectZPos = this.canConnectTo(world, i2, j2, k2 + 1);
        boolean connectZNeg = this.canConnectTo(world, i2, j2, k2 - 1);
        return AxisAlignedBB.getBoundingBoxFromPool((float)i2 + (connectXNeg ? 0.0f : 0.375f), j2, (float)k2 + (connectZNeg ? 0.0f : 0.375f), (float)(i2 + 1) - (connectXPos ? 0.0f : 0.375f), (float)j2 + 1.5f, (float)(k2 + 1) - (connectZPos ? 0.0f : 0.375f));
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        return this.getCollisionBoundingBoxFromPool(world, i2, j2, k2).expand(0.0, -0.25, 0.0).offset(0.0, -0.25, 0.0);
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int i2, int j2, int k2) {
        AxisAlignedBB aabb = this.getCollisionBoundingBoxFromPool(world, i2, j2, k2);
        this.minX = aabb.minX - (double)i2;
        this.minY = aabb.minY - (double)j2;
        this.minZ = aabb.minZ - (double)k2;
        this.maxX = aabb.maxX - (double)i2;
        this.maxY = aabb.maxY - (double)j2 - 0.5;
        this.maxZ = aabb.maxZ - (double)k2;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 11;
    }

    public boolean canConnectTo(IBlockAccess iblockaccess, int i2, int j2, int k2) {
        int l2 = iblockaccess.getBlockId(i2, j2, k2);
        return Block.blocksList[l2] != null && Block.blocksList[l2].canFenceConnectTo;
    }
}

