/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.World;
import net.minecraft.src.helper.Direction;
import net.minecraft.src.helper.PlacementMode;

public class BlockFenceGate
extends Block {
    public BlockFenceGate(int i2) {
        super(i2, Material.wood);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        int l2 = world.getBlockMetadata(i2, j2, k2);
        if (BlockFenceGate.func_35291_d(l2)) {
            return null;
        }
        return this.getAABBFromMeta(l2).expand(0.0, 0.25, 0.0).offset(i2, (float)j2 + 0.25f, k2);
    }

    private AxisAlignedBB getAABBFromMeta(int meta) {
        if (BlockFenceGate.func_35290_f(meta) == 3 || BlockFenceGate.func_35290_f(meta) == 1) {
            return AxisAlignedBB.getBoundingBoxFromPool(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
        }
        return AxisAlignedBB.getBoundingBoxFromPool(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        return this.getAABBFromMeta(world.getBlockMetadata(i2, j2, k2)).offset(i2, j2, k2);
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int i2, int j2, int k2) {
        AxisAlignedBB aabb = this.getAABBFromMeta(world.getBlockMetadata(i2, j2, k2));
        this.minX = aabb.minX;
        this.minY = aabb.minY;
        this.minZ = aabb.minZ;
        this.maxX = aabb.maxX;
        this.maxY = aabb.maxY;
        this.maxZ = aabb.maxZ;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 18;
    }

    @Override
    public void onBlockPlaced(World world, int x2, int y2, int z2, Direction side, EntityLiving player, double sideHeight) {
        int l2 = player.getHorizontalPlacementDirection((Direction)side, (PlacementMode)PlacementMode.FACING).index;
        int meta = world.getBlockMetadata(x2, y2, z2);
        world.setBlockMetadataWithNotify(x2, y2, z2, l2 | meta & 0xF0);
    }

    @Override
    public boolean blockActivated(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        int l2 = world.getBlockMetadata(i2, j2, k2);
        if (BlockFenceGate.func_35291_d(l2)) {
            world.setBlockMetadataWithNotify(i2, j2, k2, l2 & 0xFFFFFFFB);
        } else {
            int i1 = (MathHelper.floor_double((double)(entityplayer.rotationYaw * 4.0f / 360.0f) + 0.5) & 3) % 4;
            int j1 = BlockFenceGate.func_35290_f(l2);
            if (j1 == (i1 + 2) % 4) {
                l2 = l2 & 0xF0 | i1;
            }
            world.setBlockMetadataWithNotify(i2, j2, k2, l2 | 4);
        }
        if (Math.random() < 0.5) {
            world.playSoundAtEntity(entityplayer, "random.door_open", 1.0f, 1.0f);
        } else {
            world.playSoundAtEntity(entityplayer, "random.door_close", 1.0f, 1.0f);
        }
        return true;
    }

    public static boolean func_35291_d(int i2) {
        return (i2 & 4) != 0;
    }

    public static int func_35290_f(int i2) {
        return i2 & 3;
    }
}

