/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockMoss;
import net.minecraft.src.BlockPortal;
import net.minecraft.src.BlockTNT;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockFire
extends Block {
    private int[] chanceToEncourageFire = new int[Block.blocksList.length];
    private int[] abilityToCatchFire = new int[Block.blocksList.length];

    public BlockFire(int i2) {
        super(i2, Material.fire);
        this.setTickOnLoad(true);
    }

    @Override
    public void initializeBlock() {
        this.setBurnRate(Block.planksOak.blockID, 5, 20);
        this.setBurnRate(Block.planksOakPainted.blockID, 5, 20);
        this.setBurnRate(Block.fencePlanksOak.blockID, 5, 20);
        this.setBurnRate(Block.fencePlanksOakPainted.blockID, 5, 20);
        this.setBurnRate(Block.slabPlanksOak.blockID, 5, 20);
        this.setBurnRate(Block.slabPlanksOakPainted.blockID, 5, 20);
        this.setBurnRate(Block.stairsPlanksOak.blockID, 5, 20);
        this.setBurnRate(Block.logOak.blockID, 5, 5);
        this.setBurnRate(Block.logPine.blockID, 5, 5);
        this.setBurnRate(Block.logBirch.blockID, 5, 5);
        this.setBurnRate(Block.logCherry.blockID, 5, 5);
        this.setBurnRate(Block.logOakMossy.blockID, 5, 5);
        this.setBurnRate(Block.logEucalyptus.blockID, 5, 5);
        this.setBurnRate(Block.leavesOak.blockID, 30, 60);
        this.setBurnRate(Block.leavesPine.blockID, 30, 60);
        this.setBurnRate(Block.leavesBirch.blockID, 30, 60);
        this.setBurnRate(Block.leavesCherry.blockID, 30, 60);
        this.setBurnRate(Block.leavesCherryFlowering.blockID, 30, 60);
        this.setBurnRate(Block.leavesOakRetro.blockID, 30, 60);
        this.setBurnRate(Block.leavesShrub.blockID, 30, 60);
        this.setBurnRate(Block.leavesEucalyptus.blockID, 30, 60);
        this.setBurnRate(Block.bookshelfPlanksOak.blockID, 30, 20);
        this.setBurnRate(Block.tnt.blockID, 15, 100);
        this.setBurnRate(Block.wool.blockID, 30, 60);
        this.setBurnRate(Block.mossStone.blockID, 100, 30);
        this.setBurnRate(Block.mossBasalt.blockID, 100, 30);
        this.setBurnRate(Block.mossLimestone.blockID, 100, 30);
        this.setBurnRate(Block.mossGranite.blockID, 100, 30);
    }

    private void setBurnRate(int id2, int chanceToEncourageFire, int abilityToCatchFire) {
        this.chanceToEncourageFire[id2] = chanceToEncourageFire;
        this.abilityToCatchFire[id2] = abilityToCatchFire;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 3;
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return 0;
    }

    @Override
    public int tickRate() {
        return 40;
    }

    public void setBurnResult(World world, int x2, int y2, int z2) {
        world.setBlockWithNotify(x2, y2, z2, this.getBurnResultId(world, x2, y2, z2));
    }

    @Override
    public void updateTick(World world, int x2, int y2, int z2, Random random) {
        boolean infiniBurn;
        boolean bl2 = infiniBurn = world.getBlockId(x2, y2 - 1, z2) == Block.netherrack.blockID;
        if (!this.canFirePersist(world, x2, y2, z2)) {
            this.setBurnResult(world, x2, y2, z2);
        }
        if (!infiniBurn && world.currentWeather != null && world.currentWeather.isPrecipitation && (world.canBlockBeRainedOn(x2, y2, z2) || world.canBlockBeRainedOn(x2 - 1, y2, z2) || world.canBlockBeRainedOn(x2 + 1, y2, z2) || world.canBlockBeRainedOn(x2, y2, z2 - 1) || world.canBlockBeRainedOn(x2, y2, z2 + 1))) {
            this.setBurnResult(world, x2, y2, z2);
            return;
        }
        int meta = world.getBlockMetadata(x2, y2, z2);
        if (meta < 15) {
            world.setBlockMetadata(x2, y2, z2, meta + random.nextInt(3) / 2);
        }
        world.scheduleBlockUpdate(x2, y2, z2, this.blockID, this.tickRate());
        if (!infiniBurn && !this.canNeighborCatchFire(world, x2, y2, z2)) {
            if (!world.isBlockNormalCube(x2, y2 - 1, z2) || meta > 3) {
                this.setBurnResult(world, x2, y2, z2);
            }
            return;
        }
        if (!infiniBurn && !this.canBlockCatchFire(world, x2, y2 - 1, z2) && meta == 15 && random.nextInt(4) == 0) {
            this.setBurnResult(world, x2, y2, z2);
            return;
        }
        this.tryToCatchBlockOnFire(world, x2 + 1, y2, z2, 300, random, meta);
        this.tryToCatchBlockOnFire(world, x2 - 1, y2, z2, 300, random, meta);
        this.tryToCatchBlockOnFire(world, x2, y2 - 1, z2, 250, random, meta);
        this.tryToCatchBlockOnFire(world, x2, y2 + 1, z2, 250, random, meta);
        this.tryToCatchBlockOnFire(world, x2, y2, z2 - 1, 300, random, meta);
        this.tryToCatchBlockOnFire(world, x2, y2, z2 + 1, 300, random, meta);
        for (int x1 = x2 - 1; x1 <= x2 + 1; ++x1) {
            for (int z1 = z2 - 1; z1 <= z2 + 1; ++z1) {
                for (int y1 = y2 - 1; y1 <= y2 + 4; ++y1) {
                    int c2;
                    int b2;
                    if (x1 == x2 && y1 == y2 && z1 == z2) continue;
                    int a2 = 100;
                    if (y1 > y2 + 1) {
                        a2 += (y1 - (y2 + 1)) * 100;
                    }
                    if ((b2 = this.getChanceOfNeighborsEncouragingFire(world, x1, y1, z1)) <= 0 || (c2 = (b2 + 40) / (meta + 30)) <= 0 || random.nextInt(a2) > c2 || world.currentWeather != null && world.currentWeather.isPrecipitation && world.canBlockBeRainedOn(x1, y1, z1) || world.canBlockBeRainedOn(x1 - 1, y1, z2) || world.canBlockBeRainedOn(x1 + 1, y1, z1) || world.canBlockBeRainedOn(x1, y1, z1 - 1) || world.canBlockBeRainedOn(x1, y1, z1 + 1) || this.getBurnResultId(world, x1, y1, z1) != 0) continue;
                    world.setBlockAndMetadataWithNotify(x1, y1, z1, this.blockID, Math.min(meta + random.nextInt(5) / 4, 15));
                }
            }
        }
    }

    private void tryToCatchBlockOnFire(World world, int x2, int y2, int z2, int chance, Random random, int meta) {
        if (random.nextInt(chance) < this.abilityToCatchFire[world.getBlockId(x2, y2, z2)]) {
            boolean isTNT;
            boolean bl2 = isTNT = world.getBlockId(x2, y2, z2) == Block.tnt.blockID;
            if (random.nextInt(meta + 10) < 5 && !world.canBlockBeRainedOn(x2, y2, z2)) {
                if (this.getBurnResultId(world, x2, y2, z2) == 0) {
                    world.setBlockAndMetadataWithNotify(x2, y2, z2, this.blockID, Math.min(meta + random.nextInt(5) / 4, 15));
                }
            } else {
                this.setBurnResult(world, x2, y2, z2);
            }
            if (isTNT) {
                BlockTNT blockTNT = (BlockTNT)Block.tnt;
                blockTNT.ignite(world, x2, y2, z2, true);
            }
        }
    }

    private boolean canNeighborCatchFire(World world, int x2, int y2, int z2) {
        if (this.canBlockCatchFire(world, x2 + 1, y2, z2)) {
            return true;
        }
        if (this.canBlockCatchFire(world, x2 - 1, y2, z2)) {
            return true;
        }
        if (this.canBlockCatchFire(world, x2, y2 - 1, z2)) {
            return true;
        }
        if (this.canBlockCatchFire(world, x2, y2 + 1, z2)) {
            return true;
        }
        if (this.canBlockCatchFire(world, x2, y2, z2 - 1)) {
            return true;
        }
        return this.canBlockCatchFire(world, x2, y2, z2 + 1);
    }

    private int getChanceOfNeighborsEncouragingFire(World world, int i2, int j2, int k2) {
        int l2 = 0;
        if (!world.isAirBlock(i2, j2, k2)) {
            return 0;
        }
        l2 = this.getChanceToEncourageFire(world, i2 + 1, j2, k2, l2);
        l2 = this.getChanceToEncourageFire(world, i2 - 1, j2, k2, l2);
        l2 = this.getChanceToEncourageFire(world, i2, j2 - 1, k2, l2);
        l2 = this.getChanceToEncourageFire(world, i2, j2 + 1, k2, l2);
        l2 = this.getChanceToEncourageFire(world, i2, j2, k2 - 1, l2);
        l2 = this.getChanceToEncourageFire(world, i2, j2, k2 + 1, l2);
        return l2;
    }

    @Override
    public boolean isCollidable() {
        return false;
    }

    public boolean canBlockCatchFire(IBlockAccess iblockaccess, int i2, int j2, int k2) {
        return this.chanceToEncourageFire[iblockaccess.getBlockId(i2, j2, k2)] > 0;
    }

    public int getChanceToEncourageFire(World world, int i2, int j2, int k2, int l2) {
        int i1 = this.chanceToEncourageFire[world.getBlockId(i2, j2, k2)];
        if (i1 > l2) {
            return i1;
        }
        return l2;
    }

    public boolean canFirePersist(World world, int x2, int y2, int z2) {
        return world.isBlockNormalCube(x2, y2 - 1, z2) || this.canNeighborCatchFire(world, x2, y2, z2);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x2, int y2, int z2) {
        return this.canFirePersist(world, x2, y2, z2);
    }

    @Override
    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        if (!world.isBlockNormalCube(i2, j2 - 1, k2) && !this.canNeighborCatchFire(world, i2, j2, k2)) {
            world.setBlockWithNotify(i2, j2, k2, this.getBurnResultId(world, i2, j2, k2));
            return;
        }
    }

    protected int getBurnResultId(World world, int x2, int y2, int z2) {
        int id2 = world.getBlockId(x2, y2, z2);
        Block stoneBlock = BlockMoss.getStoneBlock(id2);
        if (stoneBlock != null) {
            return stoneBlock.blockID;
        }
        return 0;
    }

    @Override
    public void onBlockAdded(World world, int i2, int j2, int k2) {
        if (world.getBlockId(i2, j2 - 1, k2) == Block.obsidian.blockID && ((BlockPortal)Block.portalNether).tryToCreatePortal(world, i2, j2, k2)) {
            return;
        }
        if (!world.isBlockNormalCube(i2, j2 - 1, k2) && !this.canNeighborCatchFire(world, i2, j2, k2)) {
            world.setBlockWithNotify(i2, j2, k2, this.getBurnResultId(world, i2, j2, k2));
        } else {
            world.scheduleBlockUpdate(i2, j2, k2, this.blockID, this.tickRate());
        }
    }

    @Override
    public void randomDisplayTick(World world, int i2, int j2, int k2, Random random) {
        block12: {
            block11: {
                if (random.nextInt(24) == 0) {
                    world.playSoundEffect((float)i2 + 0.5f, (float)j2 + 0.5f, (float)k2 + 0.5f, "fire.fire", 1.0f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f);
                }
                if (!world.isBlockNormalCube(i2, j2 - 1, k2) && !((BlockFire)Block.fire).canBlockCatchFire(world, i2, j2 - 1, k2)) break block11;
                for (int l2 = 0; l2 < 3; ++l2) {
                    float f2 = (float)i2 + random.nextFloat();
                    float f6 = (float)j2 + random.nextFloat() * 0.5f + 0.5f;
                    float f12 = (float)k2 + random.nextFloat();
                    world.spawnParticle("largesmoke", f2, f6, f12, 0.0, 0.0, 0.0);
                }
                break block12;
            }
            if (((BlockFire)Block.fire).canBlockCatchFire(world, i2 - 1, j2, k2)) {
                for (int i1 = 0; i1 < 2; ++i1) {
                    float f1 = (float)i2 + random.nextFloat() * 0.1f;
                    float f7 = (float)j2 + random.nextFloat();
                    float f13 = (float)k2 + random.nextFloat();
                    world.spawnParticle("largesmoke", f1, f7, f13, 0.0, 0.0, 0.0);
                }
            }
            if (((BlockFire)Block.fire).canBlockCatchFire(world, i2 + 1, j2, k2)) {
                for (int j1 = 0; j1 < 2; ++j1) {
                    float f2 = (float)(i2 + 1) - random.nextFloat() * 0.1f;
                    float f8 = (float)j2 + random.nextFloat();
                    float f14 = (float)k2 + random.nextFloat();
                    world.spawnParticle("largesmoke", f2, f8, f14, 0.0, 0.0, 0.0);
                }
            }
            if (((BlockFire)Block.fire).canBlockCatchFire(world, i2, j2, k2 - 1)) {
                for (int k1 = 0; k1 < 2; ++k1) {
                    float f3 = (float)i2 + random.nextFloat();
                    float f9 = (float)j2 + random.nextFloat();
                    float f15 = (float)k2 + random.nextFloat() * 0.1f;
                    world.spawnParticle("largesmoke", f3, f9, f15, 0.0, 0.0, 0.0);
                }
            }
            if (((BlockFire)Block.fire).canBlockCatchFire(world, i2, j2, k2 + 1)) {
                for (int l1 = 0; l1 < 2; ++l1) {
                    float f4 = (float)i2 + random.nextFloat();
                    float f10 = (float)j2 + random.nextFloat();
                    float f16 = (float)(k2 + 1) - random.nextFloat() * 0.1f;
                    world.spawnParticle("largesmoke", f4, f10, f16, 0.0, 0.0, 0.0);
                }
            }
            if (!((BlockFire)Block.fire).canBlockCatchFire(world, i2, j2 + 1, k2)) break block12;
            for (int i22 = 0; i22 < 2; ++i22) {
                float f5 = (float)i2 + random.nextFloat();
                float f11 = (float)(j2 + 1) - random.nextFloat() * 0.1f;
                float f17 = (float)k2 + random.nextFloat();
                world.spawnParticle("largesmoke", f5, f11, f17, 0.0, 0.0, 0.0);
            }
        }
    }
}

