/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFluid;
import net.minecraft.src.Dimension;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockFluidFlowing
extends BlockFluid {
    int numAdjacentSources = 0;
    boolean[] isOptimalFlowDirection = new boolean[4];
    int[] flowCost = new int[4];

    public BlockFluidFlowing(int i2, Material material) {
        super(i2, material);
    }

    private void func_30003_j(World world, int i2, int j2, int k2) {
        int l2 = world.getBlockMetadata(i2, j2, k2);
        world.setBlockAndMetadata(i2, j2, k2, this.blockID + 1, l2);
        world.markBlocksDirty(i2, j2, k2, i2, j2, k2);
        world.markBlockNeedsUpdate(i2, j2, k2);
    }

    @Override
    public void updateTick(World world, int x2, int y2, int z2, Random random) {
        int l2 = this.getFlowDecay(world, x2, y2, z2);
        int byte0 = 1;
        if (this.blockMaterial == Material.lava && world.dimension != Dimension.nether) {
            byte0 = 2;
        }
        boolean flag = true;
        if (l2 > 0) {
            int i1 = -100;
            this.numAdjacentSources = 0;
            i1 = this.getSmallestFlowDecay(world, x2 - 1, y2, z2, i1);
            i1 = this.getSmallestFlowDecay(world, x2 + 1, y2, z2, i1);
            i1 = this.getSmallestFlowDecay(world, x2, y2, z2 - 1, i1);
            int j1 = (i1 = this.getSmallestFlowDecay(world, x2, y2, z2 + 1, i1)) + byte0;
            if (j1 >= 8 || i1 < 0) {
                j1 = -1;
            }
            if (this.getFlowDecay(world, x2, y2 + 1, z2) >= 0) {
                int l1 = this.getFlowDecay(world, x2, y2 + 1, z2);
                j1 = l1 >= 8 ? l1 : l1 + 8;
            }
            if (this.numAdjacentSources >= 2 && this.blockMaterial == Material.water) {
                if (world.getBlockMaterial(x2, y2 - 1, z2).isSolid()) {
                    j1 = 0;
                } else if (world.getBlockMaterial(x2, y2 - 1, z2) == this.blockMaterial && world.getBlockMetadata(x2, y2 - 1, z2) == 0) {
                    j1 = 0;
                }
            }
            if (this.blockMaterial == Material.lava && l2 < 8 && j1 < 8 && j1 > l2 && random.nextInt(4) != 0) {
                j1 = l2;
                flag = false;
            }
            if (j1 != l2) {
                l2 = j1;
                if (l2 < 0) {
                    world.setBlockWithNotify(x2, y2, z2, 0);
                } else {
                    world.setBlockMetadataWithNotify(x2, y2, z2, l2);
                    world.scheduleBlockUpdate(x2, y2, z2, this.blockID, this.tickRate());
                    world.notifyBlocksOfNeighborChange(x2, y2, z2, this.blockID);
                }
            } else if (flag) {
                this.func_30003_j(world, x2, y2, z2);
            }
        } else {
            this.func_30003_j(world, x2, y2, z2);
        }
        if (this.liquidCanDisplaceBlock(world, x2, y2 - 1, z2)) {
            int id2 = world.getBlockId(x2, y2 - 1, z2);
            int meta = world.getBlockMetadata(x2, y2 - 1, z2);
            if (id2 > 0) {
                Block.blocksList[id2].dropBlockAsItem(world, x2, y2 - 1, z2, meta);
            }
            if (l2 >= 8) {
                world.setBlockAndMetadataWithNotify(x2, y2 - 1, z2, this.blockID, l2);
            } else {
                world.setBlockAndMetadataWithNotify(x2, y2 - 1, z2, this.blockID, l2 + 8);
            }
        } else if (l2 >= 0 && (l2 == 0 || this.blockBlocksFlow(world, x2, y2 - 1, z2))) {
            boolean[] aflag = this.getOptimalFlowDirections(world, x2, y2, z2);
            int k1 = l2 + byte0;
            if (l2 >= 8) {
                k1 = 1;
            }
            if (k1 >= 8) {
                return;
            }
            if (aflag[0]) {
                this.flowIntoBlock(world, x2 - 1, y2, z2, k1);
            }
            if (aflag[1]) {
                this.flowIntoBlock(world, x2 + 1, y2, z2, k1);
            }
            if (aflag[2]) {
                this.flowIntoBlock(world, x2, y2, z2 - 1, k1);
            }
            if (aflag[3]) {
                this.flowIntoBlock(world, x2, y2, z2 + 1, k1);
            }
        }
    }

    private void flowIntoBlock(World world, int i2, int j2, int k2, int l2) {
        if (this.liquidCanDisplaceBlock(world, i2, j2, k2)) {
            int i1 = world.getBlockId(i2, j2, k2);
            if (i1 > 0) {
                if (this.blockMaterial == Material.lava) {
                    this.triggerLavaMixEffects(world, i2, j2, k2);
                } else {
                    Block.blocksList[i1].dropBlockAsItem(world, i2, j2, k2, world.getBlockMetadata(i2, j2, k2));
                }
            }
            world.setBlockAndMetadataWithNotify(i2, j2, k2, this.blockID, l2);
        }
    }

    private int calculateFlowCost(World world, int i2, int j2, int k2, int l2, int i1) {
        int j1 = 1000;
        for (int k1 = 0; k1 < 4; ++k1) {
            int k22;
            if (k1 == 0 && i1 == 1 || k1 == 1 && i1 == 0 || k1 == 2 && i1 == 3 || k1 == 3 && i1 == 2) continue;
            int l1 = i2;
            int i22 = j2;
            int j22 = k2;
            if (k1 == 0) {
                --l1;
            }
            if (k1 == 1) {
                ++l1;
            }
            if (k1 == 2) {
                --j22;
            }
            if (k1 == 3) {
                ++j22;
            }
            if (this.blockBlocksFlow(world, l1, i22, j22) || world.getBlockMaterial(l1, i22, j22) == this.blockMaterial && world.getBlockMetadata(l1, i22, j22) == 0) continue;
            if (!this.blockBlocksFlow(world, l1, i22 - 1, j22)) {
                return l2;
            }
            if (l2 >= 4 || (k22 = this.calculateFlowCost(world, l1, i22, j22, l2 + 1, k1)) >= j1) continue;
            j1 = k22;
        }
        return j1;
    }

    private boolean[] getOptimalFlowDirections(World world, int i2, int j2, int k2) {
        for (int l2 = 0; l2 < 4; ++l2) {
            this.flowCost[l2] = 1000;
            int j1 = i2;
            int i22 = j2;
            int j22 = k2;
            if (l2 == 0) {
                --j1;
            }
            if (l2 == 1) {
                ++j1;
            }
            if (l2 == 2) {
                --j22;
            }
            if (l2 == 3) {
                ++j22;
            }
            if (this.blockBlocksFlow(world, j1, i22, j22) || world.getBlockMaterial(j1, i22, j22) == this.blockMaterial && world.getBlockMetadata(j1, i22, j22) == 0) continue;
            this.flowCost[l2] = !this.blockBlocksFlow(world, j1, i22 - 1, j22) ? 0 : this.calculateFlowCost(world, j1, i22, j22, 1, l2);
        }
        int i1 = this.flowCost[0];
        for (int k1 = 1; k1 < 4; ++k1) {
            if (this.flowCost[k1] >= i1) continue;
            i1 = this.flowCost[k1];
        }
        for (int l1 = 0; l1 < 4; ++l1) {
            this.isOptimalFlowDirection[l1] = this.flowCost[l1] == i1;
        }
        return this.isOptimalFlowDirection;
    }

    private boolean blockBlocksFlow(World world, int i2, int j2, int k2) {
        int l2 = world.getBlockId(i2, j2, k2);
        if (l2 == Block.doorPlanksOakBottom.blockID || l2 == Block.doorIronBottom.blockID || l2 == Block.doorPlanksOakTop.blockID || l2 == Block.doorIronTop.blockID || l2 == Block.signPostPlanksOak.blockID || l2 == Block.ladderOak.blockID || l2 == Block.sugarcane.blockID) {
            return true;
        }
        if (l2 == 0) {
            return false;
        }
        Material material = Block.blocksList[l2].blockMaterial;
        return material.getIsSolid();
    }

    protected int getSmallestFlowDecay(World world, int i2, int j2, int k2, int l2) {
        int i1 = this.getFlowDecay(world, i2, j2, k2);
        if (i1 < 0) {
            return l2;
        }
        if (i1 == 0) {
            ++this.numAdjacentSources;
        }
        if (i1 >= 8) {
            i1 = 0;
        }
        return l2 >= 0 && i1 >= l2 ? l2 : i1;
    }

    private boolean liquidCanDisplaceBlock(World world, int i2, int j2, int k2) {
        Material material = world.getBlockMaterial(i2, j2, k2);
        if (material == this.blockMaterial) {
            return false;
        }
        if (material == Material.lava) {
            return false;
        }
        return !this.blockBlocksFlow(world, i2, j2, k2);
    }

    @Override
    public void onBlockAdded(World world, int i2, int j2, int k2) {
        super.onBlockAdded(world, i2, j2, k2);
        if (world.getBlockId(i2, j2, k2) == this.blockID) {
            world.scheduleBlockUpdate(i2, j2, k2, this.blockID, this.tickRate());
        }
    }
}

