/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainerRotatable;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityFurnace;
import net.minecraft.src.World;

public class BlockFurnace
extends BlockContainerRotatable {
    protected Random furnaceRand = new Random();
    protected final boolean isActive;
    protected static boolean keepFurnaceInventory = false;

    public BlockFurnace(int i2, boolean flag) {
        super(i2, Material.rock);
        this.isActive = flag;
    }

    @Override
    public int idDropped(int i2, Random random) {
        return Block.furnaceStoneIdle.blockID;
    }

    @Override
    public void onBlockAdded(World world, int i2, int j2, int k2) {
        super.onBlockAdded(world, i2, j2, k2);
        this.setDefaultDirection(world, i2, j2, k2);
    }

    @Override
    public void randomDisplayTick(World world, int i2, int j2, int k2, Random random) {
        if (!this.isActive) {
            return;
        }
        int l2 = world.getBlockMetadata(i2, j2, k2);
        float f2 = (float)i2 + 0.5f;
        float f1 = (float)j2 + 0.0f + random.nextFloat() * 6.0f / 16.0f;
        float f22 = (float)k2 + 0.5f;
        float f3 = 0.52f;
        float f4 = random.nextFloat() * 0.6f - 0.3f;
        if (l2 == 4) {
            world.spawnParticle("smoke", f2 - f3, f1, f22 + f4, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", f2 - f3, f1, f22 + f4, 0.0, 0.0, 0.0);
        } else if (l2 == 5) {
            world.spawnParticle("smoke", f2 + f3, f1, f22 + f4, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", f2 + f3, f1, f22 + f4, 0.0, 0.0, 0.0);
        } else if (l2 == 2) {
            world.spawnParticle("smoke", f2 + f4, f1, f22 - f3, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", f2 + f4, f1, f22 - f3, 0.0, 0.0, 0.0);
        } else if (l2 == 3) {
            world.spawnParticle("smoke", f2 + f4, f1, f22 + f3, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", f2 + f4, f1, f22 + f3, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean blockActivated(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        if (!world.isMultiplayerAndNotHost) {
            TileEntityFurnace tileentityfurnace = (TileEntityFurnace)world.getBlockTileEntity(i2, j2, k2);
            entityplayer.displayGUIFurnace(tileentityfurnace);
        }
        return true;
    }

    public static void updateFurnaceBlockState(boolean flag, World world, int i2, int j2, int k2) {
        int l2 = world.getBlockMetadata(i2, j2, k2);
        TileEntity tileentity = world.getBlockTileEntity(i2, j2, k2);
        keepFurnaceInventory = true;
        if (flag) {
            world.setBlockWithNotify(i2, j2, k2, Block.furnaceStoneActive.blockID);
        } else {
            world.setBlockWithNotify(i2, j2, k2, Block.furnaceStoneIdle.blockID);
        }
        keepFurnaceInventory = false;
        world.setBlockMetadataWithNotify(i2, j2, k2, l2);
        tileentity.validate();
        world.setBlockTileEntity(i2, j2, k2, tileentity);
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntityFurnace();
    }

    @Override
    public void onBlockRemoval(World world, int i2, int j2, int k2) {
        if (!keepFurnaceInventory) {
            TileEntityFurnace tileentityfurnace = (TileEntityFurnace)world.getBlockTileEntity(i2, j2, k2);
            for (int l2 = 0; l2 < tileentityfurnace.getSizeInventory(); ++l2) {
                ItemStack itemstack = tileentityfurnace.getStackInSlot(l2);
                if (itemstack == null) continue;
                float f2 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                float f1 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                float f22 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int i1 = this.furnaceRand.nextInt(21) + 10;
                    if (i1 > itemstack.stackSize) {
                        i1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= i1;
                    EntityItem entityitem = new EntityItem(world, (float)i2 + f2, (float)j2 + f1, (float)k2 + f22, new ItemStack(itemstack.itemID, i1, itemstack.getMetadata()));
                    float f3 = 0.05f;
                    entityitem.motionX = (float)this.furnaceRand.nextGaussian() * f3;
                    entityitem.motionY = (float)this.furnaceRand.nextGaussian() * f3 + 0.2f;
                    entityitem.motionZ = (float)this.furnaceRand.nextGaussian() * f3;
                    world.entityJoinedWorld(entityitem);
                }
            }
        }
        super.onBlockRemoval(world, i2, j2, k2);
    }
}

