/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.ColorizerGrass;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.Season;
import net.minecraft.src.World;

public class BlockGrass
extends Block {
    public BlockGrass(int i2, Material material) {
        super(i2, material);
        this.setTickOnLoad(true);
    }

    @Override
    public int getBlockTexture(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        Material material = iblockaccess.getBlockMaterial(i2, j2 + 1, k2);
        if (!(material != Material.snow && material != Material.builtSnow || l2 != 4 && l2 != 5 && l2 != 2 && l2 != 3)) {
            return BlockGrass.texCoordToIndex(4, 4);
        }
        return super.getBlockTexture(iblockaccess, i2, j2, k2, l2);
    }

    public int func_35274_i() {
        double d2 = 0.5;
        double d1 = 0.5;
        return ColorizerGrass.getGrassColor(d2, d1);
    }

    @Override
    public int getRenderColor(int i2) {
        return this.func_35274_i();
    }

    @Override
    public int colorMultiplier(World world, IBlockAccess iblockaccess, int i2, int j2, int k2) {
        Season season;
        double localTemperature = iblockaccess.getWorldChunkManager().getTemperature(i2, k2);
        double localHumidity = iblockaccess.getWorldChunkManager().getHumidity(i2, k2);
        int baseGrassColor = ColorizerGrass.getGrassColor(localTemperature, localHumidity);
        if (world != null && (season = world.getCurrentSeason()) != null) {
            float progress = (float)world.dayInSeason / (float)(season.lengthTicks / Minecraft.DAY_LENGTH_TICKS);
            baseGrassColor = season.modifyGrassColorizer(baseGrassColor, progress > 0.5f ? world.getNextSeason() : world.getLastSeason(), Math.abs(progress - 0.5f));
        }
        return baseGrassColor;
    }

    @Override
    public void updateTick(World world, int i2, int j2, int k2, Random random) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        if (world.getBlockLightValue(i2, j2 + 1, k2) < 4 && Block.lightOpacity[world.getBlockId(i2, j2 + 1, k2)] > 2) {
            if (random.nextInt(4) != 0) {
                return;
            }
            world.setBlockWithNotify(i2, j2, k2, Block.dirt.blockID);
        } else if (world.getBlockLightValue(i2, j2 + 1, k2) >= 9) {
            int l2 = i2 + random.nextInt(3) - 1;
            int i1 = j2 + random.nextInt(5) - 3;
            int j1 = k2 + random.nextInt(3) - 1;
            int k1 = world.getBlockId(l2, i1 + 1, j1);
            if (world.getBlockId(l2, i1, j1) == Block.dirt.blockID && world.getBlockLightValue(l2, i1 + 1, j1) >= 4 && Block.lightOpacity[k1] <= 2 && world.currentSeason != Season.surfaceWinter) {
                world.setBlockWithNotify(l2, i1, j1, this.blockID);
            }
            if (world.getBlockId(i2, j2 + 1, k2) == 0 && world.currentSeason != null && world.currentSeason.growFlowers && random.nextInt(256) == 0) {
                int idToSpawn = 0;
                int r2 = random.nextInt(400);
                idToSpawn = r2 < 26 ? Block.flowerRed.blockID : (r2 < 41 ? Block.flowerYellow.blockID : (random.nextInt(8) == 0 ? Block.tallgrassFern.blockID : Block.tallgrass.blockID));
                world.setBlockWithNotify(i2, j2 + 1, k2, idToSpawn);
            }
        }
    }

    @Override
    public int idDropped(int i2, Random random) {
        return Block.dirt.idDropped(0, random);
    }
}

