/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockBreakable;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EnumLightType;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockIce
extends BlockBreakable {
    public BlockIce(int i2) {
        super(i2, Material.ice, false);
        this.slipperiness = 0.98f;
        this.setTickOnLoad(true);
    }

    @Override
    public int getRenderBlockPass() {
        return 1;
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        return super.shouldSideBeRendered(iblockaccess, i2, j2, k2, 1 - l2);
    }

    @Override
    public void harvestBlock(World world, EntityPlayer entityplayer, int i2, int j2, int k2, int l2) {
        super.harvestBlock(world, entityplayer, i2, j2, k2, l2);
        Material material = world.getBlockMaterial(i2, j2 - 1, k2);
        if (material.getIsSolid() || material.getIsLiquid()) {
            world.setBlockWithNotify(i2, j2, k2, Block.fluidWaterFlowing.blockID);
        }
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return 0;
    }

    @Override
    public void updateTick(World world, int i2, int j2, int k2, Random random) {
        if (world.getSavedLightValue(EnumLightType.Block, i2, j2, k2) > 11 - Block.lightOpacity[this.blockID]) {
            this.dropBlockAsItem(world, i2, j2, k2, world.getBlockMetadata(i2, j2, k2));
            world.setBlockWithNotify(i2, j2, k2, Block.fluidWaterStill.blockID);
        }
    }

    @Override
    public int getMobilityFlag() {
        return 0;
    }
}

