/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityRecordPlayer;
import net.minecraft.src.World;

public class BlockJukeBox
extends BlockContainer {
    public BlockJukeBox(int i2) {
        super(i2, Material.wood);
    }

    @Override
    public boolean blockActivated(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        if (world.getBlockMetadata(i2, j2, k2) == 0) {
            return false;
        }
        this.playRecord(world, i2, j2, k2);
        return true;
    }

    public void ejectRecord(World world, int i2, int j2, int k2, int l2) {
        if (!world.isMultiplayerAndNotHost) {
            TileEntityRecordPlayer tileentityrecordplayer = (TileEntityRecordPlayer)world.getBlockTileEntity(i2, j2, k2);
            tileentityrecordplayer.record = l2;
            tileentityrecordplayer.onInventoryChanged();
            world.setBlockMetadataWithNotify(i2, j2, k2, 1);
        }
    }

    public void playRecord(World world, int i2, int j2, int k2) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        TileEntityRecordPlayer tileentityrecordplayer = (TileEntityRecordPlayer)world.getBlockTileEntity(i2, j2, k2);
        int l2 = tileentityrecordplayer.record;
        if (l2 != 0) {
            world.playSoundEffect(1005, i2, j2, k2, 0);
            world.playRecord(null, i2, j2, k2);
            tileentityrecordplayer.record = 0;
            tileentityrecordplayer.onInventoryChanged();
            world.setBlockMetadataWithNotify(i2, j2, k2, 0);
            int i1 = l2;
            float f2 = 0.7f;
            double d2 = (double)(world.rand.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
            double d1 = (double)(world.rand.nextFloat() * f2) + (double)(1.0f - f2) * 0.2 + 0.6;
            double d22 = (double)(world.rand.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)i2 + d2, (double)j2 + d1, (double)k2 + d22, new ItemStack(i1, 1, 0));
            entityitem.delayBeforeCanPickup = 10;
            world.entityJoinedWorld(entityitem);
        }
    }

    @Override
    public void onBlockRemoval(World world, int i2, int j2, int k2) {
        this.playRecord(world, i2, j2, k2);
        super.onBlockRemoval(world, i2, j2, k2);
    }

    @Override
    public void dropBlockAsItemWithChance(World world, int i2, int j2, int k2, int l2, float f2) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        super.dropBlockAsItemWithChance(world, i2, j2, k2, l2, f2);
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntityRecordPlayer();
    }
}

