/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockLamp
extends Block {
    boolean isActive;

    public BlockLamp(int i2, boolean isActivated) {
        super(i2, Material.rock);
        this.isActive = isActivated;
        this.setTickOnLoad(true);
    }

    @Override
    public int tickRate() {
        return 2;
    }

    @Override
    public int colorMultiplier(World world, IBlockAccess iblockaccess, int i2, int j2, int k2) {
        int meta = world.getBlockMetadata(i2, j2, k2);
        return this.getRenderColor(meta);
    }

    @Override
    public void onBlockAdded(World world, int i2, int j2, int k2) {
        super.onBlockAdded(world, i2, j2, k2);
        world.scheduleBlockUpdate(i2, j2, k2, this.blockID, this.tickRate());
    }

    @Override
    public int getBlockTexture(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        return this.atlasIndices[l2];
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i2, int j2) {
        return BlockLamp.texCoordToIndex(5, 12);
    }

    @Override
    public int getRenderColor(int i2) {
        switch (i2) {
            case 0: {
                return 0xFFFFFF;
            }
            case 1: {
                return 16741412;
            }
            case 2: {
                return 13795801;
            }
            case 3: {
                return 11058687;
            }
            case 4: {
                return 16772393;
            }
            case 5: {
                return 3014426;
            }
            case 6: {
                return 16728734;
            }
            case 7: {
                return 0x7D7D7D;
            }
            case 8: {
                return 0xBBC9C9;
            }
            case 9: {
                return 5097983;
            }
            case 10: {
                return 9707004;
            }
            case 11: {
                return 660223;
            }
            case 12: {
                return 0x663300;
            }
            case 13: {
                return 6861568;
            }
            case 14: {
                return 16717583;
            }
            case 15: {
                return 0x363636;
            }
        }
        return 0xFFFFFF;
    }

    public static int func_21034_c(int i2) {
        return ~i2 & 0xF;
    }

    public static int getMetadataForColour(int i2) {
        return ~i2 & 0xF;
    }

    @Override
    public void updateTick(World world, int i2, int j2, int k2, Random random) {
        boolean isPoweredByBlock;
        boolean bl2 = isPoweredByBlock = world.isBlockGettingPowered(i2, j2, k2) || world.isBlockIndirectlyGettingPowered(i2, j2, k2);
        if (this.isActive) {
            if (!isPoweredByBlock) {
                world.setBlockAndMetadataWithNotify(i2, j2, k2, Block.lampIdle.blockID, world.getBlockMetadata(i2, j2, k2));
            }
        } else if (isPoweredByBlock) {
            world.setBlockAndMetadataWithNotify(i2, j2, k2, Block.lampActive.blockID, world.getBlockMetadata(i2, j2, k2));
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        world.scheduleBlockUpdate(i2, j2, k2, this.blockID, this.tickRate());
    }

    @Override
    public int idDropped(int i2, Random random) {
        return Block.lampIdle.blockID;
    }

    @Override
    protected int damageDropped(int i2) {
        return i2;
    }
}

