/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public abstract class BlockLayerBase
extends Block {
    public int fullBlockID = -1;

    public BlockLayerBase(int i2, Material material) {
        super(i2, material);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
    }

    @Override
    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
    }

    public Block setFullBlockID(int id2) {
        this.fullBlockID = id2;
        return this;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        int l2 = world.getBlockMetadata(i2, j2, k2) & 7;
        float f2 = (float)(2 * (1 + l2)) / 16.0f;
        return AxisAlignedBB.getBoundingBoxFromPool((double)i2 + this.minX, (double)j2 + this.minY, (double)k2 + this.minZ, (double)i2 + this.maxX, (float)j2 + f2, (double)k2 + this.maxZ);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int i2, int j2, int k2) {
        int l2 = world.getBlockMetadata(i2, j2, k2) & 7;
        float f2 = (float)(2 * (1 + l2)) / 16.0f;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, f2, 1.0f);
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        return super.shouldSideBeRendered(iblockaccess, i2, j2, k2, l2);
    }
}

