/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockLayerBase;
import net.minecraft.src.BlockLeavesBase;
import net.minecraft.src.ColorProperties;
import net.minecraft.src.ColorizerFoliage;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.Season;
import net.minecraft.src.StatList;
import net.minecraft.src.World;

public class BlockLayerLeaves
extends BlockLayerBase {
    public BlockLayerLeaves(int i2, Material material) {
        super(i2, material);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        this.setTickOnLoad(true);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        return null;
    }

    @Override
    public int getRenderColor(int i2) {
        return ColorProperties.fRGB2iRGB(ColorProperties.oak.inventoryR, ColorProperties.oak.inventoryG, ColorProperties.oak.inventoryB);
    }

    @Override
    public int colorMultiplier(World world, IBlockAccess iblockaccess, int i2, int j2, int k2) {
        int baseFoliageColor = ColorProperties.fRGB2iRGB(ColorProperties.oak.inventoryR, ColorProperties.oak.inventoryG, ColorProperties.oak.inventoryB);
        if (world != null) {
            double localTemperature = iblockaccess.getWorldChunkManager().getTemperature(i2, k2);
            double localHumidity = iblockaccess.getWorldChunkManager().getHumidity(i2, k2);
            Season season = world.getCurrentSeason();
            if (season != null) {
                float progress = world.getSeasonProgress();
                baseFoliageColor = ColorizerFoliage.getSeasonalColor(season, progress, localTemperature, localHumidity, ColorProperties.oak, true);
            }
        }
        return baseFoliageColor;
    }

    public void accumulate(World world, int x2, int y2, int z2) {
        boolean negZValid;
        boolean negXValid;
        boolean posZValid;
        boolean posXValid;
        int myMetadata = world.getBlockMetadata(x2, y2, z2);
        if (myMetadata == 7) {
            return;
        }
        boolean bl2 = posXValid = world.isBlockOpaqueCube(x2 + 1, y2, z2) || world.getBlockId(x2 + 1, y2, z2) == this.blockID && world.getBlockMetadata(x2 + 1, y2, z2) >= myMetadata;
        if (!posXValid) {
            return;
        }
        boolean bl3 = posZValid = world.isBlockOpaqueCube(x2, y2, z2 + 1) || world.getBlockId(x2, y2, z2 + 1) == this.blockID && world.getBlockMetadata(x2, y2, z2 + 1) >= myMetadata;
        if (!posZValid) {
            return;
        }
        boolean bl4 = negXValid = world.isBlockOpaqueCube(x2 - 1, y2, z2) || world.getBlockId(x2 - 1, y2, z2) == this.blockID && world.getBlockMetadata(x2 - 1, y2, z2) >= myMetadata;
        if (!negXValid) {
            return;
        }
        boolean bl5 = negZValid = world.isBlockOpaqueCube(x2, y2, z2 - 1) || world.getBlockId(x2, y2, z2 - 1) == this.blockID && world.getBlockMetadata(x2, y2, z2 - 1) >= myMetadata;
        if (!negZValid) {
            return;
        }
        world.setBlockMetadata(x2, y2, z2, myMetadata + 1);
        world.markBlockNeedsUpdate(x2, y2, z2);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i2, int j2, int k2) {
        int l2 = world.getBlockId(i2, j2 - 1, k2);
        if (l2 == 0 || !Block.blocksList[l2].isOpaqueCube() && !(Block.blocksList[l2] instanceof BlockLeavesBase)) {
            return false;
        }
        Material material = world.getBlockMaterial(i2, j2 - 1, k2);
        return material.getIsSolid();
    }

    @Override
    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        this.func_314_h(world, i2, j2, k2);
    }

    private boolean func_314_h(World world, int i2, int j2, int k2) {
        if (!this.canPlaceBlockAt(world, i2, j2, k2)) {
            this.dropBlockAsItem(world, i2, j2, k2, world.getBlockMetadata(i2, j2, k2));
            world.setBlockWithNotify(i2, j2, k2, 0);
            return false;
        }
        return true;
    }

    @Override
    public void harvestBlock(World world, EntityPlayer entityplayer, int i2, int j2, int k2, int l2) {
        if (!world.isMultiplayerAndNotHost && entityplayer.getCurrentEquippedItem() != null && entityplayer.getCurrentEquippedItem().itemID == Item.toolShears.itemID) {
            entityplayer.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            world.dropItem(i2, j2, k2, new ItemStack(this.blockID, l2 + 1, 0));
        } else {
            super.harvestBlock(world, entityplayer, i2, j2, k2, l2);
        }
    }

    @Override
    public int idDropped(int i2, Random random) {
        return 0;
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return 0;
    }

    @Override
    public void updateTick(World world, int i2, int j2, int k2, Random random) {
        if (world.currentSeason != null && !world.currentSeason.hasFallingLeaves) {
            int metadata = world.getBlockMetadata(i2, j2, k2);
            if (random.nextInt(2) == 0) {
                if (metadata > 0) {
                    world.setBlockMetadata(i2, j2, k2, metadata - 1);
                } else {
                    world.setBlockWithNotify(i2, j2, k2, 0);
                }
            }
        }
    }
}

