/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockLayerBase;
import net.minecraft.src.BlockLeavesBase;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EnumLightType;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.Season;
import net.minecraft.src.World;

public class BlockLayerSnow
extends BlockLayerBase {
    public BlockLayerSnow(int i2, Material material) {
        super(i2, material);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        this.setTickOnLoad(true);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        int l2 = world.getBlockMetadata(i2, j2, k2) & 7;
        float f2 = (float)(2 * (1 + l2)) / 16.0f;
        return AxisAlignedBB.getBoundingBoxFromPool((double)i2 + this.minX, (double)j2 + this.minY, (double)k2 + this.minZ, (double)i2 + this.maxX, (float)j2 + f2 - 0.125f, (double)k2 + this.maxZ);
    }

    public void accumulate(World world, int x2, int y2, int z2) {
        boolean negZValid;
        boolean negXValid;
        boolean posZValid;
        boolean posXValid;
        int myMetadata = world.getBlockMetadata(x2, y2, z2);
        if (myMetadata == 7) {
            return;
        }
        boolean bl2 = posXValid = world.isBlockOpaqueCube(x2 + 1, y2, z2) || world.getBlockId(x2 + 1, y2, z2) == this.blockID && world.getBlockMetadata(x2 + 1, y2, z2) >= myMetadata;
        if (!posXValid) {
            return;
        }
        boolean bl3 = posZValid = world.isBlockOpaqueCube(x2, y2, z2 + 1) || world.getBlockId(x2, y2, z2 + 1) == this.blockID && world.getBlockMetadata(x2, y2, z2 + 1) >= myMetadata;
        if (!posZValid) {
            return;
        }
        boolean bl4 = negXValid = world.isBlockOpaqueCube(x2 - 1, y2, z2) || world.getBlockId(x2 - 1, y2, z2) == this.blockID && world.getBlockMetadata(x2 - 1, y2, z2) >= myMetadata;
        if (!negXValid) {
            return;
        }
        boolean bl5 = negZValid = world.isBlockOpaqueCube(x2, y2, z2 - 1) || world.getBlockId(x2, y2, z2 - 1) == this.blockID && world.getBlockMetadata(x2, y2, z2 - 1) >= myMetadata;
        if (!negZValid) {
            return;
        }
        world.setBlockMetadata(x2, y2, z2, myMetadata + 1);
        world.markBlockNeedsUpdate(x2, y2, z2);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i2, int j2, int k2) {
        int l2 = world.getBlockId(i2, j2 - 1, k2);
        if (l2 == 0 || !Block.blocksList[l2].isOpaqueCube() && !(Block.blocksList[l2] instanceof BlockLeavesBase)) {
            return false;
        }
        Material material = world.getBlockMaterial(i2, j2 - 1, k2);
        return material == Material.leaves || material.getIsSolid();
    }

    @Override
    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        this.func_314_h(world, i2, j2, k2);
    }

    private boolean func_314_h(World world, int i2, int j2, int k2) {
        if (!this.canPlaceBlockAt(world, i2, j2, k2)) {
            this.dropBlockAsItem(world, i2, j2, k2, world.getBlockMetadata(i2, j2, k2));
            world.setBlockWithNotify(i2, j2, k2, 0);
            return false;
        }
        return true;
    }

    @Override
    public void harvestBlock(World world, EntityPlayer entityplayer, int i2, int j2, int k2, int l2) {
        super.harvestBlock(world, entityplayer, i2, j2, k2, l2);
        int i1 = Item.ammoSnowball.itemID;
        float f2 = 0.7f;
        double d2 = (double)(world.rand.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
        double d1 = (double)(world.rand.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
        double d22 = (double)(world.rand.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
        EntityItem entityitem = new EntityItem(world, (double)i2 + d2, (double)j2 + d1, (double)k2 + d22, new ItemStack(i1, 1, 0));
        entityitem.delayBeforeCanPickup = 10;
        world.entityJoinedWorld(entityitem);
    }

    @Override
    public int idDropped(int i2, Random random) {
        return Item.ammoSnowball.itemID;
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return 0;
    }

    @Override
    public void updateTick(World world, int i2, int j2, int k2, Random random) {
        if (world.getSavedLightValue(EnumLightType.Block, i2, j2, k2) > 11) {
            this.dropBlockAsItem(world, i2, j2, k2, world.getBlockMetadata(i2, j2, k2));
            world.setBlockWithNotify(i2, j2, k2, 0);
        }
        if (world.getBlockBiome(i2, k2) != null && !world.getBlockBiome(i2, k2).hasSurfaceSnow() && world.getCurrentSeason() != Season.surfaceWinter) {
            this.dropBlockAsItem(world, i2, j2, k2, world.getBlockMetadata(i2, j2, k2));
            world.setBlockWithNotify(i2, j2, k2, 0);
        }
    }
}

