/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockLog;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.Season;
import net.minecraft.src.World;

public class BlockLeavesBase
extends Block {
    int[] adjacentTreeBlocks;
    protected static boolean fancyGraphics;

    public BlockLeavesBase(int i2, Material material, boolean flag) {
        super(i2, material);
        fancyGraphics = flag;
        this.setTickOnLoad(true);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i2, int j2) {
        return !fancyGraphics ? this.atlasIndices[i2] + 1 : this.atlasIndices[i2];
    }

    @Override
    public void dropBlockAsItemWithChance(World world, int i2, int j2, int k2, int l2, float f2) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        if (world.getCurrentSeason() == Season.surfaceWinter && world.rand.nextInt(5) > 0) {
            return;
        }
        int i1 = this.quantityDropped(l2, world.rand);
        if (world.getCurrentSeason() == Season.surfaceSpring && world.rand.nextInt(10) == 0) {
            ++i1;
        }
        for (int j1 = 0; j1 < i1; ++j1) {
            int k1;
            if (world.rand.nextFloat() > f2 || (k1 = this.idDropped(l2, world.rand)) <= 0) continue;
            world.dropItem(i2, j2, k2, new ItemStack(k1, 1, this.damageDropped(l2)));
        }
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        int i1 = iblockaccess.getBlockId(i2, j2, k2);
        if (!fancyGraphics && i1 == this.blockID) {
            return false;
        }
        return super.shouldSideBeRendered(iblockaccess, i2, j2, k2, l2);
    }

    @Override
    public void onBlockRemoval(World world, int i2, int j2, int k2) {
        int l2 = 1;
        int i1 = l2 + 1;
        if (world.checkChunksExist(i2 - i1, j2 - i1, k2 - i1, i2 + i1, j2 + i1, k2 + i1)) {
            for (int j1 = -l2; j1 <= l2; ++j1) {
                for (int k1 = -l2; k1 <= l2; ++k1) {
                    for (int l1 = -l2; l1 <= l2; ++l1) {
                        int i22 = world.getBlockId(i2 + j1, j2 + k1, k2 + l1);
                        if (!(Block.blocksList[i22] instanceof BlockLeavesBase)) continue;
                        int j22 = world.getBlockMetadata(i2 + j1, j2 + k1, k2 + l1);
                        world.setBlockMetadata(i2 + j1, j2 + k1, k2 + l1, j22 | 8);
                    }
                }
            }
        }
    }

    public static void setGraphicsLevel(boolean flag) {
        fancyGraphics = flag;
    }

    @Override
    public void updateTick(World world, int x2, int y2, int z2, Random random) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        int l2 = world.getBlockMetadata(x2, y2, z2);
        if ((l2 & 8) != 0) {
            int j2;
            int byte0 = 4;
            int offset = byte0 + 1;
            int length = 32;
            int xSpan = length * length;
            int halfLength = length / 2;
            if (this.adjacentTreeBlocks == null) {
                this.adjacentTreeBlocks = new int[length * length * length];
            }
            if (world.checkChunksExist(x2 - offset, y2 - offset, z2 - offset, x2 + offset, y2 + offset, z2 + offset)) {
                for (int xOffset = -byte0; xOffset <= byte0; ++xOffset) {
                    for (int yOffset = -byte0; yOffset <= byte0; ++yOffset) {
                        for (int zOffset = -byte0; zOffset <= byte0; ++zOffset) {
                            int k3 = world.getBlockId(x2 + xOffset, y2 + yOffset, z2 + zOffset);
                            this.adjacentTreeBlocks[(xOffset + halfLength) * xSpan + (yOffset + halfLength) * length + (zOffset + halfLength)] = Block.blocksList[k3] instanceof BlockLog ? 0 : (Block.blocksList[k3] instanceof BlockLeavesBase ? -2 : -1);
                        }
                    }
                }
                for (int i2 = 1; i2 <= 4; ++i2) {
                    for (int l22 = -byte0; l22 <= byte0; ++l22) {
                        for (int j3 = -byte0; j3 <= byte0; ++j3) {
                            for (int l3 = -byte0; l3 <= byte0; ++l3) {
                                if (this.adjacentTreeBlocks[(l22 + halfLength) * xSpan + (j3 + halfLength) * length + (l3 + halfLength)] != i2 - 1) continue;
                                if (this.adjacentTreeBlocks[(l22 + halfLength - 1) * xSpan + (j3 + halfLength) * length + (l3 + halfLength)] == -2) {
                                    this.adjacentTreeBlocks[(l22 + halfLength - 1) * xSpan + (j3 + halfLength) * length + (l3 + halfLength)] = i2;
                                }
                                if (this.adjacentTreeBlocks[(l22 + halfLength + 1) * xSpan + (j3 + halfLength) * length + (l3 + halfLength)] == -2) {
                                    this.adjacentTreeBlocks[(l22 + halfLength + 1) * xSpan + (j3 + halfLength) * length + (l3 + halfLength)] = i2;
                                }
                                if (this.adjacentTreeBlocks[(l22 + halfLength) * xSpan + (j3 + halfLength - 1) * length + (l3 + halfLength)] == -2) {
                                    this.adjacentTreeBlocks[(l22 + halfLength) * xSpan + (j3 + halfLength - 1) * length + (l3 + halfLength)] = i2;
                                }
                                if (this.adjacentTreeBlocks[(l22 + halfLength) * xSpan + (j3 + halfLength + 1) * length + (l3 + halfLength)] == -2) {
                                    this.adjacentTreeBlocks[(l22 + halfLength) * xSpan + (j3 + halfLength + 1) * length + (l3 + halfLength)] = i2;
                                }
                                if (this.adjacentTreeBlocks[(l22 + halfLength) * xSpan + (j3 + halfLength) * length + (l3 + halfLength - 1)] == -2) {
                                    this.adjacentTreeBlocks[(l22 + halfLength) * xSpan + (j3 + halfLength) * length + (l3 + halfLength - 1)] = i2;
                                }
                                if (this.adjacentTreeBlocks[(l22 + halfLength) * xSpan + (j3 + halfLength) * length + (l3 + halfLength + 1)] != -2) continue;
                                this.adjacentTreeBlocks[(l22 + halfLength) * xSpan + (j3 + halfLength) * length + (l3 + halfLength + 1)] = i2;
                            }
                        }
                    }
                }
            }
            if ((j2 = this.adjacentTreeBlocks[halfLength * xSpan + halfLength * length + halfLength]) >= 0) {
                world.setBlockMetadata(x2, y2, z2, l2 & 0xFFFFFFF7);
            } else {
                this.removeLeaves(world, x2, y2, z2);
            }
        }
    }

    private void removeLeaves(World world, int i2, int j2, int k2) {
        this.dropBlockAsItem(world, i2, j2, k2, world.getBlockMetadata(i2, j2, k2));
        world.setBlockWithNotify(i2, j2, k2, 0);
    }
}

