/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockLeavesBase;
import net.minecraft.src.ColorProperties;
import net.minecraft.src.ColorizerFoliage;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.Season;
import net.minecraft.src.StatList;
import net.minecraft.src.World;

public class BlockLeavesCherry
extends BlockLeavesBase {
    public BlockLeavesCherry(int i2) {
        super(i2, Material.leaves, false);
    }

    @Override
    public int getRenderColor(int i2) {
        return ColorProperties.fRGB2iRGB(ColorProperties.cherry.inventoryR, ColorProperties.cherry.inventoryG, ColorProperties.cherry.inventoryB);
    }

    @Override
    public int colorMultiplier(World world, IBlockAccess iblockaccess, int i2, int j2, int k2) {
        int baseFoliageColor = ColorProperties.fRGB2iRGB(ColorProperties.cherry.inventoryR, ColorProperties.cherry.inventoryG, ColorProperties.cherry.inventoryB);
        if (world != null) {
            double localTemperature = iblockaccess.getWorldChunkManager().getTemperature(i2, k2);
            double localHumidity = iblockaccess.getWorldChunkManager().getHumidity(i2, k2);
            Season season = world.getCurrentSeason();
            if (season != null) {
                float progress = world.getSeasonProgress();
                baseFoliageColor = ColorizerFoliage.getSeasonalColor(season, progress, localTemperature, localHumidity, ColorProperties.cherry);
            }
        }
        return baseFoliageColor;
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return random.nextInt(20) != 0 ? 0 : 1;
    }

    @Override
    public int idDropped(int i2, Random random) {
        return Block.saplingCherry.blockID;
    }

    @Override
    public void harvestBlock(World world, EntityPlayer entityplayer, int i2, int j2, int k2, int l2) {
        if (!world.isMultiplayerAndNotHost && entityplayer.getCurrentEquippedItem() != null && entityplayer.getCurrentEquippedItem().itemID == Item.toolShears.itemID) {
            entityplayer.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            world.dropItem(i2, j2, k2, new ItemStack(this.blockID, 1, l2 & 3));
        } else {
            super.harvestBlock(world, entityplayer, i2, j2, k2, l2);
        }
    }

    @Override
    public void randomDisplayTick(World world, int i2, int j2, int k2, Random random) {
        if (world.getCurrentSeason() != null && world.getCurrentSeason() == Season.surfaceSpring && random.nextInt(40) == 0) {
            world.spawnParticle("fallingleaf", i2, (float)j2 - 0.1f, k2, 0.0, 0.0, 0.0);
        }
    }
}

