/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.BlockLeavesCherry;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.Season;
import net.minecraft.src.World;

public class BlockLeavesCherryFlowering
extends BlockLeavesCherry {
    public BlockLeavesCherryFlowering(int i2) {
        super(i2);
    }

    @Override
    public int getRenderType() {
        return 23;
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        if (metadata != 1) {
            return 0;
        }
        return random.nextInt(2) + 1;
    }

    @Override
    public int idDropped(int i2, Random random) {
        return Item.cherry.itemID;
    }

    @Override
    public void onBlockClicked(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        this.blockActivated(world, i2, j2, k2, entityplayer);
    }

    @Override
    public boolean blockActivated(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        if (world.getBlockMetadata(i2, j2, k2) == 1) {
            Random rand = new Random();
            world.playSoundAtEntity(entityplayer, "random.pop", 0.2f, 0.5f);
            if (!world.isMultiplayerAndNotHost) {
                this.dropBlockAsItem(world, i2, j2, k2, 1);
            }
            world.setBlockMetadataWithNotify(i2, j2, k2, 0);
            world.scheduleBlockUpdate(i2, j2, k2, BlockLeavesCherryFlowering.leavesCherryFlowering.blockID, this.tickRate());
            return true;
        }
        return super.blockActivated(world, i2, j2, k2, entityplayer);
    }

    @Override
    public void updateTick(World world, int x2, int y2, int z2, Random random) {
        super.updateTick(world, x2, y2, z2, random);
        int metadata = world.getBlockMetadata(x2, y2, z2);
        if (world.getCurrentSeason() == Season.surfaceSpring) {
            if (random.nextInt(20) == 0 && metadata == 0) {
                world.setBlockMetadataWithNotify(x2, y2, z2, 1);
                world.scheduleBlockUpdate(x2, y2, z2, BlockLeavesCherryFlowering.leavesCherryFlowering.blockID, this.tickRate());
            }
        } else if ((metadata & 1) == 1) {
            world.setBlockMetadataWithNotify(x2, y2, z2, 0);
            world.scheduleBlockUpdate(x2, y2, z2, BlockLeavesCherryFlowering.leavesCherryFlowering.blockID, this.tickRate());
        }
    }
}

