/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityMobSpawner;
import net.minecraft.src.World;
import net.minecraft.src.helper.Direction;

public class BlockMobSpawner
extends BlockContainer {
    public BlockMobSpawner(int i2) {
        super(i2, Material.rock);
    }

    @Override
    public TileEntity getBlockEntity() {
        return new TileEntityMobSpawner();
    }

    @Override
    public int idDropped(int i2, Random random) {
        return 0;
    }

    @Override
    public void onBlockPlaced(World world, int x2, int y2, int z2, Direction side, EntityLiving player, double sideHeight) {
        TileEntityMobSpawner tileEntity = (TileEntityMobSpawner)world.getBlockTileEntity(x2, y2, z2);
        tileEntity.setMobID("none");
    }

    @Override
    public void onBlockRemoval(World world, int i2, int j2, int k2) {
        if (!world.isMultiplayerAndNotHost) {
            TileEntityMobSpawner tileEntityMobSpawner = (TileEntityMobSpawner)world.getBlockTileEntity(i2, j2, k2);
            int amountToDrop = world.rand.nextInt(10) + 10;
            for (int l2 = 0; l2 < amountToDrop; ++l2) {
                ItemStack itemstack;
                String mobInSpawner = tileEntityMobSpawner.getMobID();
                if (mobInSpawner == null) continue;
                switch (mobInSpawner) {
                    case "Zombie": {
                        itemstack = new ItemStack(Item.cloth);
                        break;
                    }
                    case "Skeleton": {
                        if (world.rand.nextInt(2) == 0) {
                            itemstack = new ItemStack(Item.bone);
                            break;
                        }
                        itemstack = new ItemStack(Item.ammoArrow);
                        break;
                    }
                    case "ArmouredZombie": {
                        itemstack = new ItemStack(Item.chainlink);
                        break;
                    }
                    case "Spider": {
                        itemstack = new ItemStack(Item.string);
                        break;
                    }
                    default: {
                        itemstack = null;
                    }
                }
                if (itemstack == null) continue;
                float f2 = world.rand.nextFloat() * 0.8f + 0.1f;
                float f1 = world.rand.nextFloat() * 0.8f + 0.1f;
                float f22 = world.rand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int i1 = world.rand.nextInt(21) + 10;
                    if (i1 > itemstack.stackSize) {
                        i1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= i1;
                    EntityItem entityitem = new EntityItem(world, (float)i2 + f2, (float)j2 + f1, (float)k2 + f22, new ItemStack(itemstack.itemID, i1, itemstack.getMetadata()));
                    float f3 = 0.05f;
                    entityitem.motionX = (float)world.rand.nextGaussian() * f3;
                    entityitem.motionY = (float)world.rand.nextGaussian() * f3 + 0.2f;
                    entityitem.motionZ = (float)world.rand.nextGaussian() * f3;
                    world.entityJoinedWorld(entityitem);
                }
            }
        }
        super.onBlockRemoval(world, i2, j2, k2);
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return 0;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }
}

