/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.ColorizerGrass;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.Season;
import net.minecraft.src.World;

public class BlockMoss
extends Block {
    public static final Map<Block, Block> stoneToMossMap = new HashMap<Block, Block>();
    public static final Map<Block, Block> mossToStoneMap = new HashMap<Block, Block>();

    public BlockMoss(int i2) {
        super(i2, Material.moss);
        this.setTickOnLoad(true);
    }

    @Override
    public int getRenderType() {
        return 21;
    }

    public int func_35274_i() {
        double d2 = 0.5;
        double d1 = 0.5;
        return ColorizerGrass.getGrassColor(d2, d1);
    }

    @Override
    public int getRenderColor(int i2) {
        return this.func_35274_i();
    }

    @Override
    public int colorMultiplier(World world, IBlockAccess iblockaccess, int i2, int j2, int k2) {
        Season season;
        double localTemperature = iblockaccess.getWorldChunkManager().getTemperature(i2, k2);
        double localHumidity = iblockaccess.getWorldChunkManager().getHumidity(i2, k2);
        int baseGrassColor = ColorizerGrass.getGrassColor(localTemperature, localHumidity);
        if (world != null && (season = world.getCurrentSeason()) != null) {
            float progress = (float)world.dayInSeason / (float)(season.lengthTicks / Minecraft.DAY_LENGTH_TICKS);
            baseGrassColor = season.modifyGrassColorizer(baseGrassColor, progress > 0.5f ? world.getNextSeason() : world.getLastSeason(), Math.abs(progress - 0.5f));
        }
        return baseGrassColor;
    }

    @Override
    public void updateTick(World world, int x2, int y2, int z2, Random random) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        if (this.canMossSpread(world, x2, y2, z2) && random.nextInt(20) == 0) {
            this.spreadMossRandomly(world, x2, y2, z2, random, false);
        }
    }

    public boolean spreadMossRandomly(World world, int x2, int y2, int z2, Random random, boolean ignoreLight) {
        Block mossStone;
        int mossX = x2;
        int mossY = y2;
        int mossZ = z2;
        int side = random.nextInt(6);
        if (side == 0) {
            --mossZ;
        }
        if (side == 1) {
            ++mossX;
        }
        if (side == 2) {
            ++mossZ;
        }
        if (side == 3) {
            --mossX;
        }
        if (side == 4) {
            ++mossY;
        }
        if (side == 5) {
            --mossY;
        }
        if ((ignoreLight || !Block.isBuried(world, mossX, mossY, mossZ)) && (mossStone = BlockMoss.getMossBlock(world.getBlockId(mossX, mossY, mossZ))) != null) {
            world.setBlockWithNotify(mossX, mossY, mossZ, mossStone.blockID);
            return true;
        }
        return false;
    }

    public boolean canMossSpread(World world, int x2, int y2, int z2) {
        return world.getBlockLightValue(x2, y2 + 1, z2) <= 5 && world.getBlockLightValue(x2, y2 - 1, z2) <= 5 && world.getBlockLightValue(x2 + 1, y2, z2) <= 5 && world.getBlockLightValue(x2 - 1, y2, z2) <= 5 && world.getBlockLightValue(x2, y2, z2 - 1) <= 5 && world.getBlockLightValue(x2, y2, z2 + 1) <= 5;
    }

    public static Block getMossBlock(int blockId) {
        if (blockId == 0) {
            return null;
        }
        return BlockMoss.getMossBlock(Block.blocksList[blockId]);
    }

    public static Block getMossBlock(Block stoneBlock) {
        return stoneToMossMap.get(stoneBlock);
    }

    public static Block getStoneBlock(int blockId) {
        if (blockId == 0) {
            return null;
        }
        return BlockMoss.getStoneBlock(Block.blocksList[blockId]);
    }

    public static Block getStoneBlock(Block mossBlock) {
        return mossToStoneMap.get(mossBlock);
    }

    public static void initMossMap() {
        stoneToMossMap.put(stone, mossStone);
        stoneToMossMap.put(granite, mossGranite);
        stoneToMossMap.put(limestone, mossLimestone);
        stoneToMossMap.put(basalt, mossBasalt);
        stoneToMossMap.put(cobbleStone, cobbleStoneMossy);
        stoneToMossMap.put(brickStonePolished, brickStonePolishedMossy);
        stoneToMossMap.put(logOak, logOakMossy);
        for (Map.Entry<Block, Block> entry : stoneToMossMap.entrySet()) {
            mossToStoneMap.put(entry.getValue(), entry.getKey());
        }
    }
}

