/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFlower;
import net.minecraft.src.World;

public class BlockMushroom
extends BlockFlower {
    public BlockMushroom(int i2) {
        super(i2);
        float f2 = 0.2f;
        this.setBlockBounds(0.5f - f2, 0.0f, 0.5f - f2, 0.5f + f2, f2 * 2.0f, 0.5f + f2);
        this.setTickOnLoad(true);
    }

    @Override
    public void updateTick(World world, int i2, int j2, int k2, Random random) {
        int j1;
        int i1;
        int l2;
        if (random.nextInt(100) == 0 && world.isAirBlock(l2 = i2 + random.nextInt(3) - 1, i1 = j2 + random.nextInt(2) - random.nextInt(2), j1 = k2 + random.nextInt(3) - 1) && this.canBlockStay(world, l2, i1, j1)) {
            i2 += random.nextInt(3) - 1;
            k2 += random.nextInt(3) - 1;
            if (world.isAirBlock(l2, i1, j1) && this.canBlockStay(world, l2, i1, j1)) {
                world.setBlockWithNotify(l2, i1, j1, this.blockID);
            }
        }
    }

    @Override
    protected boolean canThisPlantGrowOnThisBlockID(int i2) {
        return Block.opaqueCubeLookup[i2];
    }

    @Override
    public boolean canBlockStay(World world, int i2, int j2, int k2) {
        if (j2 < 0 || j2 >= Minecraft.WORLD_HEIGHT_BLOCKS) {
            return false;
        }
        return world.getFullBlockLightValue(i2, j2, k2) < 13 && this.canThisPlantGrowOnThisBlockID(world.getBlockId(i2, j2 - 1, k2));
    }
}

