/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityNote;
import net.minecraft.src.World;

public class BlockNote
extends BlockContainer {
    public BlockNote(int i2) {
        super(i2, Material.wood);
    }

    @Override
    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        if (l2 > 0 && Block.blocksList[l2].canProvidePower()) {
            boolean flag = world.isBlockGettingPowered(i2, j2, k2);
            TileEntityNote tileentitynote = (TileEntityNote)world.getBlockTileEntity(i2, j2, k2);
            if (tileentitynote.previousRedstoneState != flag) {
                if (flag) {
                    tileentitynote.triggerNote(world, i2, j2, k2);
                }
                tileentitynote.previousRedstoneState = flag;
            }
        }
    }

    @Override
    public boolean blockActivated(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        if (world.isMultiplayerAndNotHost) {
            return true;
        }
        TileEntityNote tileentitynote = (TileEntityNote)world.getBlockTileEntity(i2, j2, k2);
        tileentitynote.changePitch();
        tileentitynote.triggerNote(world, i2, j2, k2);
        return true;
    }

    @Override
    public void onBlockClicked(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        TileEntityNote tileentitynote = (TileEntityNote)world.getBlockTileEntity(i2, j2, k2);
        tileentitynote.triggerNote(world, i2, j2, k2);
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntityNote();
    }

    @Override
    public void playBlock(World world, int i2, int j2, int k2, int l2, int i1) {
        float f2 = (float)Math.pow(2.0, (double)(i1 - 12) / 12.0);
        String s2 = "harp";
        if (l2 == 1) {
            s2 = "bd";
        }
        if (l2 == 2) {
            s2 = "snare";
        }
        if (l2 == 3) {
            s2 = "hat";
        }
        if (l2 == 4) {
            s2 = "bassattack";
        }
        world.playSoundEffect((double)i2 + 0.5, (double)j2 + 0.5, (double)k2 + 0.5, "note." + s2, 3.0f, f2);
        world.spawnParticle("note", (double)i2 + 0.5, (double)j2 + 1.2, (double)k2 + 0.5, (double)i1 / 24.0, 0.0, 0.0);
    }
}

