/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.PistonModel;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityPiston;
import net.minecraft.src.World;

public class BlockPistonMoving
extends BlockContainer {
    public BlockPistonMoving(int i2) {
        super(i2, Material.piston);
        this.setHardness(-1.0f);
    }

    @Override
    protected TileEntity getBlockEntity() {
        return null;
    }

    @Override
    public void onBlockAdded(World world, int i2, int j2, int k2) {
    }

    @Override
    public void onBlockRemoval(World world, int i2, int j2, int k2) {
        TileEntity tileentity = world.getBlockTileEntity(i2, j2, k2);
        if (tileentity != null && tileentity instanceof TileEntityPiston) {
            ((TileEntityPiston)tileentity).clearPistonTileEntity();
        } else {
            super.onBlockRemoval(world, i2, j2, k2);
        }
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i2, int j2, int k2) {
        return false;
    }

    @Override
    public boolean canPlaceBlockOnSide(World world, int i2, int j2, int k2, int l2) {
        return false;
    }

    @Override
    public int getRenderType() {
        return -1;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean blockActivated(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        if (!world.isMultiplayerAndNotHost && world.getBlockTileEntity(i2, j2, k2) == null) {
            world.setBlockWithNotify(i2, j2, k2, 0);
            return true;
        }
        return false;
    }

    @Override
    public int idDropped(int i2, Random random) {
        return 0;
    }

    @Override
    public void dropBlockAsItemWithChance(World world, int i2, int j2, int k2, int l2, float f2) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        TileEntityPiston tileentitypiston = this.func_31034_c(world, i2, j2, k2);
        if (tileentitypiston == null) {
            return;
        }
        Block.blocksList[tileentitypiston.getStoredBlockID()].dropBlockAsItem(world, i2, j2, k2, tileentitypiston.getBlockMetadata());
    }

    @Override
    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        if (world.isMultiplayerAndNotHost || world.getBlockTileEntity(i2, j2, k2) != null) {
            // empty if block
        }
    }

    public static TileEntity func_31036_a(int i2, int j2, int k2, boolean flag, boolean flag1) {
        return new TileEntityPiston(i2, j2, k2, flag, flag1);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        TileEntityPiston tileentitypiston = this.func_31034_c(world, i2, j2, k2);
        if (tileentitypiston == null) {
            return null;
        }
        float f2 = tileentitypiston.func_31008_a(0.0f);
        if (tileentitypiston.func_31015_b()) {
            f2 = 1.0f - f2;
        }
        return this.func_31035_a(world, i2, j2, k2, tileentitypiston.getStoredBlockID(), f2, tileentitypiston.func_31009_d());
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int i2, int j2, int k2) {
        TileEntityPiston tileentitypiston = this.func_31034_c(world, i2, j2, k2);
        if (tileentitypiston != null) {
            Block block = Block.blocksList[tileentitypiston.getStoredBlockID()];
            if (block == null || block == this) {
                return;
            }
            block.setBlockBoundsBasedOnState(world, i2, j2, k2);
            float f2 = tileentitypiston.func_31008_a(0.0f);
            if (tileentitypiston.func_31015_b()) {
                f2 = 1.0f - f2;
            }
            int l2 = tileentitypiston.func_31009_d();
            this.minX = block.minX - (double)((float)PistonModel.xOffset[l2] * f2);
            this.minY = block.minY - (double)((float)PistonModel.yOffset[l2] * f2);
            this.minZ = block.minZ - (double)((float)PistonModel.zOffset[l2] * f2);
            this.maxX = block.maxX - (double)((float)PistonModel.xOffset[l2] * f2);
            this.maxY = block.maxY - (double)((float)PistonModel.yOffset[l2] * f2);
            this.maxZ = block.maxZ - (double)((float)PistonModel.zOffset[l2] * f2);
        }
    }

    public AxisAlignedBB func_31035_a(World world, int i2, int j2, int k2, int l2, float f2, int i1) {
        if (l2 == 0 || l2 == this.blockID) {
            return null;
        }
        AxisAlignedBB axisalignedbb = Block.blocksList[l2].getCollisionBoundingBoxFromPool(world, i2, j2, k2);
        if (axisalignedbb == null) {
            return null;
        }
        axisalignedbb.minX -= (double)((float)PistonModel.xOffset[i1] * f2);
        axisalignedbb.maxX -= (double)((float)PistonModel.xOffset[i1] * f2);
        axisalignedbb.minY -= (double)((float)PistonModel.yOffset[i1] * f2);
        axisalignedbb.maxY -= (double)((float)PistonModel.yOffset[i1] * f2);
        axisalignedbb.minZ -= (double)((float)PistonModel.zOffset[i1] * f2);
        axisalignedbb.maxZ -= (double)((float)PistonModel.zOffset[i1] * f2);
        return axisalignedbb;
    }

    private TileEntityPiston func_31034_c(IBlockAccess iblockaccess, int i2, int j2, int k2) {
        TileEntity tileentity = iblockaccess.getBlockTileEntity(i2, j2, k2);
        if (tileentity != null && tileentity instanceof TileEntityPiston) {
            return (TileEntityPiston)tileentity;
        }
        return null;
    }
}

