/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.BlockBreakable;
import net.minecraft.src.Entity;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockPortal
extends BlockBreakable {
    public int targetDimension;
    public int portalMaterialId;
    public int portalTriggerId;

    public BlockPortal(int id2, int targetDimension, int portalMaterialId, int portalTriggerId) {
        super(id2, Material.portal, false);
        this.targetDimension = targetDimension;
        this.portalMaterialId = portalMaterialId;
        this.portalTriggerId = portalTriggerId;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        return null;
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int i2, int j2, int k2) {
        int meta = world.getBlockMetadata(i2, j2, k2);
        if ((meta & 1) > 0) {
            float f1 = 0.125f;
            float f3 = 0.5f;
            this.setBlockBounds(0.5f - f1, 0.0f, 0.5f - f3, 0.5f + f1, 1.0f, 0.5f + f3);
        } else {
            float f2 = 0.5f;
            float f22 = 0.125f;
            this.setBlockBounds(0.5f - f2, 0.0f, 0.5f - f22, 0.5f + f2, 1.0f, 0.5f + f22);
        }
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    public int[] getPortalDims(World world, int x2, int y2, int z2) {
        return this.getPortalDims(world, x2, y2, z2, false);
    }

    public int[] getPortalDims(World world, int x2, int y2, int z2, boolean swapOrientation) {
        int rz2;
        int rx2;
        int ry2;
        int maxDims = 32;
        int ox2 = x2;
        int oy2 = y2;
        int oz2 = z2;
        int maxBoundA = 0;
        int maxBoundY = 0;
        boolean foundBottom = false;
        boolean foundOrientation = false;
        boolean orientation = false;
        if (world.dimension.portalBlockId != -1 && world.dimension.portalBlockId != this.blockID) {
            return null;
        }
        for (ry2 = 0; ry2 > -maxDims; --ry2) {
            if (world.getBlockId(x2, y2 + ry2, z2) != this.portalMaterialId) continue;
            foundBottom = true;
            y2 += ry2;
            break;
        }
        if (!foundBottom) {
            return null;
        }
        ++y2;
        if (!swapOrientation) {
            for (rx2 = 0; rx2 > -maxDims; --rx2) {
                if (world.getBlockId(x2 + rx2, y2, z2) != this.portalMaterialId) continue;
                foundOrientation = true;
                orientation = false;
                x2 += rx2;
                break;
            }
            if (!foundOrientation) {
                for (rz2 = 0; rz2 > -maxDims; --rz2) {
                    if (world.getBlockId(x2, y2, z2 + rz2) != this.portalMaterialId) continue;
                    foundOrientation = true;
                    orientation = true;
                    z2 += rz2;
                    break;
                }
            }
        } else {
            for (rz2 = 0; rz2 > -maxDims; --rz2) {
                if (world.getBlockId(x2, y2, z2 + rz2) != this.portalMaterialId) continue;
                foundOrientation = true;
                orientation = true;
                z2 += rz2;
                break;
            }
            if (!foundOrientation) {
                for (rx2 = 0; rx2 > -maxDims; --rx2) {
                    if (world.getBlockId(x2 + rx2, y2, z2) != this.portalMaterialId) continue;
                    foundOrientation = true;
                    orientation = false;
                    x2 += rx2;
                    break;
                }
            }
        }
        if (!foundOrientation) {
            return null;
        }
        if (!orientation) {
            for (rx2 = 1; rx2 < maxDims; ++rx2) {
                if (world.getBlockId(x2 + rx2, y2, z2) != this.portalMaterialId) continue;
                maxBoundA = rx2;
                break;
            }
        } else {
            for (rz2 = 1; rz2 < maxDims; ++rz2) {
                if (world.getBlockId(x2, y2, z2 + rz2) != this.portalMaterialId) continue;
                maxBoundA = rz2;
                break;
            }
        }
        if (maxBoundA == 0) {
            return swapOrientation ? null : this.getPortalDims(world, ox2, oy2, oz2, true);
        }
        --y2;
        for (ry2 = 1; ry2 < maxDims; ++ry2) {
            if (y2 + ry2 >= Minecraft.WORLD_HEIGHT_BLOCKS) {
                return swapOrientation ? null : this.getPortalDims(world, ox2, oy2, oz2, true);
            }
            if (world.getBlockId(x2 + (!orientation ? 1 : 0), y2 + ry2, z2 + (orientation ? 1 : 0)) != this.portalMaterialId) continue;
            maxBoundY = ry2;
            break;
        }
        if (maxBoundY == 0) {
            return swapOrientation ? null : this.getPortalDims(world, ox2, oy2, oz2, true);
        }
        for (int ra2 = 0; ra2 <= maxBoundA; ++ra2) {
            for (int ry3 = 0; ry3 <= maxBoundY; ++ry3) {
                int id2;
                if (!(ra2 == 0 || ra2 == maxBoundA || ry3 == 0 || ry3 == maxBoundY ? world.getBlockId(x2 + (!orientation ? ra2 : 0), y2 + ry3, z2 + (orientation ? ra2 : 0)) != this.portalMaterialId : (id2 = world.getBlockId(x2 + (!orientation ? ra2 : 0), y2 + ry3, z2 + (orientation ? ra2 : 0))) != 0 && id2 != this.portalTriggerId && id2 != this.blockID)) continue;
                return swapOrientation ? null : this.getPortalDims(world, ox2, oy2, oz2, true);
            }
        }
        return new int[]{orientation ? 1 : 0, x2, y2, z2, maxBoundA, maxBoundY};
    }

    public boolean tryToCreatePortal(World world, int x2, int y2, int z2) {
        int[] bounds = this.getPortalDims(world, x2, y2, z2);
        if (bounds == null) {
            return false;
        }
        x2 = bounds[1];
        y2 = bounds[2];
        z2 = bounds[3];
        world.editingBlocks = true;
        for (int ra2 = 1; ra2 < bounds[4]; ++ra2) {
            for (int ry2 = 1; ry2 < bounds[5]; ++ry2) {
                world.setBlockAndMetadata(x2 + (bounds[0] == 0 ? ra2 : 0), y2 + ry2, z2 + (bounds[0] == 1 ? ra2 : 0), this.blockID, bounds[0] & 1);
            }
        }
        world.setBlockMetadata(x2 + (bounds[0] == 0 ? 1 : 0), y2 + 1, z2 + (bounds[0] == 1 ? 1 : 0), bounds[0] & 0xF | 2);
        world.markBlocksDirty(x2 + (bounds[0] == 0 ? 1 : 0), y2 + 1, z2 + (bounds[0] == 1 ? 1 : 0), x2 + (bounds[0] == 0 ? bounds[4] : 0), y2 + bounds[5], z2 + (bounds[0] == 1 ? bounds[4] : 0));
        world.editingBlocks = false;
        return true;
    }

    @Override
    public void onNeighborBlockChange(World world, int x2, int y2, int z2, int id2) {
        int[] bounds = this.getPortalDims(world, x2, y2, z2);
        if (bounds == null) {
            world.setBlockWithNotify(x2, y2, z2, 0);
            return;
        }
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        boolean flag5;
        if (iblockaccess.getBlockId(i2, j2, k2) == this.blockID) {
            return false;
        }
        boolean flag = iblockaccess.getBlockId(i2 - 1, j2, k2) == this.blockID && iblockaccess.getBlockId(i2 - 2, j2, k2) != this.blockID;
        boolean flag1 = iblockaccess.getBlockId(i2 + 1, j2, k2) == this.blockID && iblockaccess.getBlockId(i2 + 2, j2, k2) != this.blockID;
        boolean flag2 = iblockaccess.getBlockId(i2, j2, k2 - 1) == this.blockID && iblockaccess.getBlockId(i2, j2, k2 - 2) != this.blockID;
        boolean flag3 = iblockaccess.getBlockId(i2, j2, k2 + 1) == this.blockID && iblockaccess.getBlockId(i2, j2, k2 + 2) != this.blockID;
        boolean flag4 = flag || flag1;
        boolean bl2 = flag5 = flag2 || flag3;
        if (flag4 && l2 == 4) {
            return true;
        }
        if (flag4 && l2 == 5) {
            return true;
        }
        if (flag5 && l2 == 2) {
            return true;
        }
        return flag5 && l2 == 3;
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return 0;
    }

    @Override
    public int getRenderBlockPass() {
        return 1;
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int i2, int j2, int k2, Entity entity) {
        if (entity.ridingEntity == null && entity.riddenByEntity == null) {
            entity.setInPortal(this.blockID);
        }
    }

    @Override
    public void randomDisplayTick(World world, int i2, int j2, int k2, Random random) {
        int meta = world.getBlockMetadata(i2, j2, k2);
        if ((meta & 2) > 0 && random.nextInt(20) == 0) {
            world.playSoundEffect((double)i2 + 0.5, (double)j2 + 0.5, (double)k2 + 0.5, "portal.portal", 0.5f, random.nextFloat() * 0.4f + 0.8f);
        }
        for (int l2 = 0; l2 < 4; ++l2) {
            double d2 = (float)i2 + random.nextFloat();
            double d1 = (float)j2 + random.nextFloat();
            double d22 = (float)k2 + random.nextFloat();
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            int i1 = random.nextInt(2) * 2 - 1;
            d3 = ((double)random.nextFloat() - 0.5) * 0.5;
            d4 = ((double)random.nextFloat() - 0.5) * 0.5;
            d5 = ((double)random.nextFloat() - 0.5) * 0.5;
            if (world.getBlockId(i2 - 1, j2, k2) == this.blockID || world.getBlockId(i2 + 1, j2, k2) == this.blockID) {
                d22 = (double)k2 + 0.5 + 0.25 * (double)i1;
                d5 = random.nextFloat() * 2.0f * (float)i1;
            } else {
                d2 = (double)i2 + 0.5 + 0.25 * (double)i1;
                d3 = random.nextFloat() * 2.0f * (float)i1;
            }
            world.spawnParticle("portal", d2, d1, d22, d3, d4, d5);
        }
    }
}

