/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.RailLogic;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public class BlockRail
extends Block {
    private final boolean isPowered;

    public static final boolean isRailBlockAt(World world, int i2, int j2, int k2) {
        int l2 = world.getBlockId(i2, j2, k2);
        return l2 == Block.rail.blockID || l2 == Block.railPowered.blockID || l2 == Block.railDetector.blockID;
    }

    public static final boolean isRailBlock(int i2) {
        return i2 == Block.rail.blockID || i2 == Block.railPowered.blockID || i2 == Block.railDetector.blockID;
    }

    protected BlockRail(int i2, boolean flag) {
        super(i2, Material.circuits);
        this.isPowered = flag;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
    }

    public boolean getIsPowered() {
        return this.isPowered;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public MovingObjectPosition collisionRayTrace(World world, int i2, int j2, int k2, Vec3D vec3d, Vec3D vec3d1) {
        this.setBlockBoundsBasedOnState(world, i2, j2, k2);
        return super.collisionRayTrace(world, i2, j2, k2, vec3d, vec3d1);
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int i2, int j2, int k2) {
        int l2 = world.getBlockMetadata(i2, j2, k2);
        if (l2 >= 2 && l2 <= 5) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.625f, 1.0f);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        }
    }

    @Override
    public int getBlockOverbright(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        if (this.blockID != Block.railPowered.blockID || (iblockaccess.getBlockMetadata(i2, j2, k2) & 8) == 0) {
            return -1;
        }
        return BlockRail.texCoordToIndex(0, 16);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i2, int j2) {
        if (this.isPowered) {
            if (this.blockID == Block.railPowered.blockID && (j2 & 8) == 0) {
                return BlockRail.texCoordToIndex(3, 10);
            }
            if (this.blockID == Block.railPowered.blockID) {
                return BlockRail.texCoordToIndex(3, 11);
            }
        } else if (j2 >= 6) {
            return BlockRail.texCoordToIndex(0, 7);
        }
        return BlockRail.texCoordToIndex(0, 8);
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 9;
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return 1;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i2, int j2, int k2) {
        return world.canPlaceOnSurfaceOfBlock(i2, j2 - 1, k2);
    }

    @Override
    public void onBlockAdded(World world, int i2, int j2, int k2) {
        if (!world.isMultiplayerAndNotHost) {
            this.func_4031_h(world, i2, j2, k2, true);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        boolean flag;
        int i1;
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        int j1 = i1 = world.getBlockMetadata(i2, j2, k2);
        if (this.isPowered) {
            j1 &= 7;
        }
        boolean bl2 = flag = !world.canPlaceOnSurfaceOfBlock(i2, j2 - 1, k2);
        if (j1 == 2 && !world.canPlaceOnSurfaceOfBlock(i2 + 1, j2, k2)) {
            flag = true;
        }
        if (j1 == 3 && !world.canPlaceOnSurfaceOfBlock(i2 - 1, j2, k2)) {
            flag = true;
        }
        if (j1 == 4 && !world.canPlaceOnSurfaceOfBlock(i2, j2, k2 - 1)) {
            flag = true;
        }
        if (j1 == 5 && !world.canPlaceOnSurfaceOfBlock(i2, j2, k2 + 1)) {
            flag = true;
        }
        if (flag) {
            this.dropBlockAsItem(world, i2, j2, k2, world.getBlockMetadata(i2, j2, k2));
            world.setBlockWithNotify(i2, j2, k2, 0);
        } else if (this.blockID == Block.railPowered.blockID) {
            boolean flag1 = world.isBlockIndirectlyGettingPowered(i2, j2, k2) || world.isBlockIndirectlyGettingPowered(i2, j2 + 1, k2);
            flag1 = flag1 || this.func_27044_a(world, i2, j2, k2, i1, true, 0) || this.func_27044_a(world, i2, j2, k2, i1, false, 0);
            boolean flag2 = false;
            if (flag1 && (i1 & 8) == 0) {
                world.setBlockMetadataWithNotify(i2, j2, k2, j1 | 8);
                flag2 = true;
            } else if (!flag1 && (i1 & 8) != 0) {
                world.setBlockMetadataWithNotify(i2, j2, k2, j1);
                flag2 = true;
            }
            if (flag2) {
                world.notifyBlocksOfNeighborChange(i2, j2 - 1, k2, this.blockID);
                if (j1 == 2 || j1 == 3 || j1 == 4 || j1 == 5) {
                    world.notifyBlocksOfNeighborChange(i2, j2 + 1, k2, this.blockID);
                }
            }
        } else if (l2 > 0 && Block.blocksList[l2].canProvidePower() && !this.isPowered && RailLogic.getNAdjacentTracks(new RailLogic(this, world, i2, j2, k2)) == 3) {
            this.func_4031_h(world, i2, j2, k2, false);
        }
    }

    private void func_4031_h(World world, int i2, int j2, int k2, boolean flag) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        new RailLogic(this, world, i2, j2, k2).func_792_a(world.isBlockIndirectlyGettingPowered(i2, j2, k2), flag);
    }

    private boolean func_27044_a(World world, int i2, int j2, int k2, int l2, boolean flag, int i1) {
        if (i1 >= 8) {
            return false;
        }
        int j1 = l2 & 7;
        boolean flag1 = true;
        switch (j1) {
            case 0: {
                if (flag) {
                    ++k2;
                    break;
                }
                --k2;
                break;
            }
            case 1: {
                if (flag) {
                    --i2;
                    break;
                }
                ++i2;
                break;
            }
            case 2: {
                if (flag) {
                    --i2;
                } else {
                    ++i2;
                    ++j2;
                    flag1 = false;
                }
                j1 = 1;
                break;
            }
            case 3: {
                if (flag) {
                    --i2;
                    ++j2;
                    flag1 = false;
                } else {
                    ++i2;
                }
                j1 = 1;
                break;
            }
            case 4: {
                if (flag) {
                    ++k2;
                } else {
                    --k2;
                    ++j2;
                    flag1 = false;
                }
                j1 = 0;
                break;
            }
            case 5: {
                if (flag) {
                    ++k2;
                    ++j2;
                    flag1 = false;
                } else {
                    --k2;
                }
                j1 = 0;
            }
        }
        if (this.func_27043_a(world, i2, j2, k2, flag, i1, j1)) {
            return true;
        }
        return flag1 && this.func_27043_a(world, i2, j2 - 1, k2, flag, i1, j1);
    }

    private boolean func_27043_a(World world, int i2, int j2, int k2, boolean flag, int l2, int i1) {
        int j1 = world.getBlockId(i2, j2, k2);
        if (j1 == Block.railPowered.blockID) {
            int k1 = world.getBlockMetadata(i2, j2, k2);
            int l1 = k1 & 7;
            if (i1 == 1 && (l1 == 0 || l1 == 4 || l1 == 5)) {
                return false;
            }
            if (i1 == 0 && (l1 == 1 || l1 == 2 || l1 == 3)) {
                return false;
            }
            if ((k1 & 8) != 0) {
                if (world.isBlockIndirectlyGettingPowered(i2, j2, k2) || world.isBlockIndirectlyGettingPowered(i2, j2 + 1, k2)) {
                    return true;
                }
                return this.func_27044_a(world, i2, j2, k2, k1, flag, l2 + 1);
            }
        }
        return false;
    }

    @Override
    public int getMobilityFlag() {
        return 0;
    }

    static boolean isPoweredBlockRail(BlockRail blockrail) {
        return blockrail.isPowered;
    }
}

