/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockRedstone
extends Block {
    public BlockRedstone(int i2, Material material) {
        super(i2, material);
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public boolean isPoweringTo(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        return true;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int i2, int j2, int k2, int l2) {
        return this.isPoweringTo(world, i2, j2, k2, l2);
    }

    @Override
    public void onBlockAdded(World world, int i2, int j2, int k2) {
        world.notifyBlocksOfNeighborChange(i2, j2 - 1, k2, this.blockID);
        world.notifyBlocksOfNeighborChange(i2, j2 + 1, k2, this.blockID);
        world.notifyBlocksOfNeighborChange(i2 - 1, j2, k2, this.blockID);
        world.notifyBlocksOfNeighborChange(i2 + 1, j2, k2, this.blockID);
        world.notifyBlocksOfNeighborChange(i2, j2, k2 - 1, this.blockID);
        world.notifyBlocksOfNeighborChange(i2, j2, k2 + 1, this.blockID);
    }

    @Override
    public void onBlockRemoval(World world, int i2, int j2, int k2) {
        world.notifyBlocksOfNeighborChange(i2, j2 - 1, k2, this.blockID);
        world.notifyBlocksOfNeighborChange(i2, j2 + 1, k2, this.blockID);
        world.notifyBlocksOfNeighborChange(i2 - 1, j2, k2, this.blockID);
        world.notifyBlocksOfNeighborChange(i2 + 1, j2, k2, this.blockID);
        world.notifyBlocksOfNeighborChange(i2, j2, k2 - 1, this.blockID);
        world.notifyBlocksOfNeighborChange(i2, j2, k2 + 1, this.blockID);
    }

    @Override
    public void randomDisplayTick(World world, int i2, int j2, int k2, Random random) {
        this.func_319_i(world, i2, j2, k2);
    }

    private void func_319_i(World world, int i2, int j2, int k2) {
        Random random = world.rand;
        double d2 = 0.0625;
        for (int l2 = 0; l2 < 6; ++l2) {
            double d1 = (float)i2 + random.nextFloat();
            double d22 = (float)j2 + random.nextFloat();
            double d3 = (float)k2 + random.nextFloat();
            if (l2 == 0 && !world.isBlockOpaqueCube(i2, j2 + 1, k2)) {
                d22 = (double)(j2 + 1) + d2;
            }
            if (l2 == 1 && !world.isBlockOpaqueCube(i2, j2 - 1, k2)) {
                d22 = (double)(j2 + 0) - d2;
            }
            if (l2 == 2 && !world.isBlockOpaqueCube(i2, j2, k2 + 1)) {
                d3 = (double)(k2 + 1) + d2;
            }
            if (l2 == 3 && !world.isBlockOpaqueCube(i2, j2, k2 - 1)) {
                d3 = (double)(k2 + 0) - d2;
            }
            if (l2 == 4 && !world.isBlockOpaqueCube(i2 + 1, j2, k2)) {
                d1 = (double)(i2 + 1) + d2;
            }
            if (l2 == 5 && !world.isBlockOpaqueCube(i2 - 1, j2, k2)) {
                d1 = (double)(i2 + 0) - d2;
            }
            if (!(d1 < (double)i2 || d1 > (double)(i2 + 1) || d22 < 0.0 || d22 > (double)(j2 + 1) || d3 < (double)k2) && !(d3 > (double)(k2 + 1))) continue;
            world.spawnParticle("reddust", d1, d22, d3, 0.0, 0.0, 0.0);
        }
    }
}

