/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.Material;
import net.minecraft.src.World;
import net.minecraft.src.helper.Direction;

public class BlockRedstoneRepeater
extends Block {
    public static final double[] field_22024_a = new double[]{-0.0625, 0.0625, 0.1875, 0.3125};
    private static final int[] field_22023_b = new int[]{1, 2, 3, 4};
    private final boolean isRepeaterPowered;

    public BlockRedstoneRepeater(int i2, boolean flag) {
        super(i2, Material.circuits);
        this.isRepeaterPowered = flag;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i2, int j2, int k2) {
        if (!world.canPlaceOnSurfaceOfBlock(i2, j2 - 1, k2)) {
            return false;
        }
        return super.canPlaceBlockAt(world, i2, j2, k2);
    }

    @Override
    public boolean canBlockStay(World world, int i2, int j2, int k2) {
        if (!world.canPlaceOnSurfaceOfBlock(i2, j2 - 1, k2)) {
            return false;
        }
        return super.canBlockStay(world, i2, j2, k2);
    }

    @Override
    public void updateTick(World world, int i2, int j2, int k2, Random random) {
        int l2 = world.getBlockMetadata(i2, j2, k2);
        boolean flag = this.func_22022_g(world, i2, j2, k2, l2);
        if (this.isRepeaterPowered && !flag) {
            world.setBlockAndMetadataWithNotify(i2, j2, k2, Block.repeaterIdle.blockID, l2);
        } else if (!this.isRepeaterPowered) {
            world.setBlockAndMetadataWithNotify(i2, j2, k2, Block.repeaterActive.blockID, l2);
            if (!flag) {
                int i1 = (l2 & 0xC) >> 2;
                world.scheduleBlockUpdate(i2, j2, k2, Block.repeaterActive.blockID, field_22023_b[i1] * 2);
            }
        }
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i2, int j2) {
        if (i2 == 0) {
            return !this.isRepeaterPowered ? BlockRedstoneRepeater.texCoordToIndex(3, 7) : BlockRedstoneRepeater.texCoordToIndex(3, 6);
        }
        if (i2 == 1) {
            return !this.isRepeaterPowered ? BlockRedstoneRepeater.texCoordToIndex(3, 8) : BlockRedstoneRepeater.texCoordToIndex(3, 9);
        }
        return BlockRedstoneRepeater.texCoordToIndex(5, 0);
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        return l2 != 0 && l2 != 1;
    }

    @Override
    public int getRenderType() {
        return 15;
    }

    @Override
    public int getBlockTextureFromSide(int i2) {
        return this.getBlockTextureFromSideAndMetadata(i2, 0);
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int i2, int j2, int k2, int l2) {
        return this.isPoweringTo(world, i2, j2, k2, l2);
    }

    @Override
    public boolean isPoweringTo(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        if (!this.isRepeaterPowered) {
            return false;
        }
        int i1 = iblockaccess.getBlockMetadata(i2, j2, k2) & 3;
        if (i1 == 0 && l2 == 3) {
            return true;
        }
        if (i1 == 1 && l2 == 4) {
            return true;
        }
        if (i1 == 2 && l2 == 2) {
            return true;
        }
        return i1 == 3 && l2 == 5;
    }

    @Override
    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        if (!this.canBlockStay(world, i2, j2, k2)) {
            this.dropBlockAsItem(world, i2, j2, k2, world.getBlockMetadata(i2, j2, k2));
            world.setBlockWithNotify(i2, j2, k2, 0);
            return;
        }
        int i1 = world.getBlockMetadata(i2, j2, k2);
        boolean flag = this.func_22022_g(world, i2, j2, k2, i1);
        int j1 = (i1 & 0xC) >> 2;
        if (this.isRepeaterPowered && !flag) {
            world.scheduleBlockUpdate(i2, j2, k2, this.blockID, field_22023_b[j1] * 2);
        } else if (!this.isRepeaterPowered && flag) {
            world.scheduleBlockUpdate(i2, j2, k2, this.blockID, field_22023_b[j1] * 2);
        }
    }

    private boolean func_22022_g(World world, int i2, int j2, int k2, int l2) {
        int i1 = l2 & 3;
        switch (i1) {
            case 0: {
                return world.isBlockIndirectlyProvidingPowerTo(i2, j2, k2 + 1, 3) || world.getBlockId(i2, j2, k2 + 1) == Block.wireRedstone.blockID && world.getBlockMetadata(i2, j2, k2 + 1) > 0;
            }
            case 2: {
                return world.isBlockIndirectlyProvidingPowerTo(i2, j2, k2 - 1, 2) || world.getBlockId(i2, j2, k2 - 1) == Block.wireRedstone.blockID && world.getBlockMetadata(i2, j2, k2 - 1) > 0;
            }
            case 3: {
                return world.isBlockIndirectlyProvidingPowerTo(i2 + 1, j2, k2, 5) || world.getBlockId(i2 + 1, j2, k2) == Block.wireRedstone.blockID && world.getBlockMetadata(i2 + 1, j2, k2) > 0;
            }
            case 1: {
                return world.isBlockIndirectlyProvidingPowerTo(i2 - 1, j2, k2, 4) || world.getBlockId(i2 - 1, j2, k2) == Block.wireRedstone.blockID && world.getBlockMetadata(i2 - 1, j2, k2) > 0;
            }
        }
        return false;
    }

    @Override
    public boolean blockActivated(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        int l2 = world.getBlockMetadata(i2, j2, k2);
        int i1 = (l2 & 0xC) >> 2;
        i1 = i1 + 1 << 2 & 0xC;
        world.setBlockMetadataWithNotify(i2, j2, k2, i1 | l2 & 3);
        return true;
    }

    @Override
    public boolean canProvidePower() {
        return false;
    }

    @Override
    public void onBlockPlaced(World world, int x2, int y2, int z2, Direction side, EntityLiving player, double sideHeight) {
        int l2 = player.getHorizontalPlacementDirection((Direction)side).getOpposite().index;
        world.setBlockMetadataWithNotify(x2, y2, z2, l2);
        boolean flag = this.func_22022_g(world, x2, y2, z2, l2);
        if (flag) {
            world.scheduleBlockUpdate(x2, y2, z2, this.blockID, 1);
        }
    }

    @Override
    public void onBlockAdded(World world, int i2, int j2, int k2) {
        world.notifyBlocksOfNeighborChange(i2 + 1, j2, k2, this.blockID);
        world.notifyBlocksOfNeighborChange(i2 - 1, j2, k2, this.blockID);
        world.notifyBlocksOfNeighborChange(i2, j2, k2 + 1, this.blockID);
        world.notifyBlocksOfNeighborChange(i2, j2, k2 - 1, this.blockID);
        world.notifyBlocksOfNeighborChange(i2, j2 - 1, k2, this.blockID);
        world.notifyBlocksOfNeighborChange(i2, j2 + 1, k2, this.blockID);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public int idDropped(int i2, Random random) {
        return Item.repeater.itemID;
    }

    @Override
    public void randomDisplayTick(World world, int i2, int j2, int k2, Random random) {
        if (!this.isRepeaterPowered) {
            return;
        }
        int l2 = world.getBlockMetadata(i2, j2, k2);
        double d2 = (double)((float)i2 + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
        double d1 = (double)((float)j2 + 0.4f) + (double)(random.nextFloat() - 0.5f) * 0.2;
        double d22 = (double)((float)k2 + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
        double d3 = 0.0;
        double d4 = 0.0;
        if (random.nextInt(2) == 0) {
            switch (l2 & 3) {
                case 0: {
                    d4 = -0.3125;
                    break;
                }
                case 2: {
                    d4 = 0.3125;
                    break;
                }
                case 3: {
                    d3 = -0.3125;
                    break;
                }
                case 1: {
                    d3 = 0.3125;
                }
            }
        } else {
            int i1 = (l2 & 0xC) >> 2;
            switch (l2 & 3) {
                case 0: {
                    d4 = field_22024_a[i1];
                    break;
                }
                case 2: {
                    d4 = -field_22024_a[i1];
                    break;
                }
                case 3: {
                    d3 = field_22024_a[i1];
                    break;
                }
                case 1: {
                    d3 = -field_22024_a[i1];
                }
            }
        }
        world.spawnParticle("reddust", d2 + d3, d1, d22 + d4, 0.0, 0.0, 0.0);
    }
}

