/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.Material;
import net.minecraft.src.ModelBed;
import net.minecraft.src.World;

public class BlockRedstoneWire
extends Block {
    private boolean wiresProvidePower = true;
    private Set field_21031_b = new HashSet();

    public BlockRedstoneWire(int i2) {
        super(i2, Material.circuits);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 5;
    }

    @Override
    public int colorMultiplier(World world, IBlockAccess iblockaccess, int i2, int j2, int k2) {
        return 0x800000;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i2, int j2, int k2) {
        return world.canPlaceOnSurfaceOfBlock(i2, j2 - 1, k2);
    }

    private void updateAndPropagateCurrentStrength(World world, int i2, int j2, int k2) {
        this.func_21030_a(world, i2, j2, k2, i2, j2, k2);
        ArrayList arraylist = new ArrayList(this.field_21031_b);
        this.field_21031_b.clear();
        for (int l2 = 0; l2 < arraylist.size(); ++l2) {
            ChunkPosition chunkposition = (ChunkPosition)arraylist.get(l2);
            world.notifyBlocksOfNeighborChange(chunkposition.x, chunkposition.y, chunkposition.z, this.blockID);
        }
    }

    private void func_21030_a(World world, int i2, int j2, int k2, int l2, int i1, int j1) {
        int k1 = world.getBlockMetadata(i2, j2, k2);
        int l1 = 0;
        this.wiresProvidePower = false;
        boolean flag = world.isBlockIndirectlyGettingPowered(i2, j2, k2);
        this.wiresProvidePower = true;
        if (flag) {
            l1 = 15;
        } else {
            for (int i22 = 0; i22 < 4; ++i22) {
                int k22 = i2;
                int i3 = k2;
                if (i22 == 0) {
                    --k22;
                }
                if (i22 == 1) {
                    ++k22;
                }
                if (i22 == 2) {
                    --i3;
                }
                if (i22 == 3) {
                    ++i3;
                }
                if (k22 != l2 || j2 != i1 || i3 != j1) {
                    l1 = this.getMaxCurrentStrength(world, k22, j2, i3, l1);
                }
                if (world.isBlockNormalCube(k22, j2, i3) && !world.isBlockNormalCube(i2, j2 + 1, k2)) {
                    if (k22 == l2 && j2 + 1 == i1 && i3 == j1) continue;
                    l1 = this.getMaxCurrentStrength(world, k22, j2 + 1, i3, l1);
                    continue;
                }
                if (world.isBlockNormalCube(k22, j2, i3) || k22 == l2 && j2 - 1 == i1 && i3 == j1) continue;
                l1 = this.getMaxCurrentStrength(world, k22, j2 - 1, i3, l1);
            }
            l1 = l1 > 0 ? --l1 : 0;
        }
        if (k1 != l1) {
            world.editingBlocks = true;
            world.setBlockMetadataWithNotify(i2, j2, k2, l1);
            world.markBlocksDirty(i2, j2, k2, i2, j2, k2);
            world.editingBlocks = false;
            for (int j22 = 0; j22 < 4; ++j22) {
                int l22 = i2;
                int j3 = k2;
                int k3 = j2 - 1;
                if (j22 == 0) {
                    --l22;
                }
                if (j22 == 1) {
                    ++l22;
                }
                if (j22 == 2) {
                    --j3;
                }
                if (j22 == 3) {
                    ++j3;
                }
                if (world.isBlockNormalCube(l22, j2, j3)) {
                    k3 += 2;
                }
                int l3 = 0;
                l3 = this.getMaxCurrentStrength(world, l22, j2, j3, -1);
                l1 = world.getBlockMetadata(i2, j2, k2);
                if (l1 > 0) {
                    --l1;
                }
                if (l3 >= 0 && l3 != l1) {
                    this.func_21030_a(world, l22, j2, j3, i2, j2, k2);
                }
                l3 = this.getMaxCurrentStrength(world, l22, k3, j3, -1);
                l1 = world.getBlockMetadata(i2, j2, k2);
                if (l1 > 0) {
                    --l1;
                }
                if (l3 < 0 || l3 == l1) continue;
                this.func_21030_a(world, l22, k3, j3, i2, j2, k2);
            }
            if (k1 == 0 || l1 == 0) {
                this.field_21031_b.add(new ChunkPosition(i2, j2, k2));
                this.field_21031_b.add(new ChunkPosition(i2 - 1, j2, k2));
                this.field_21031_b.add(new ChunkPosition(i2 + 1, j2, k2));
                this.field_21031_b.add(new ChunkPosition(i2, j2 - 1, k2));
                this.field_21031_b.add(new ChunkPosition(i2, j2 + 1, k2));
                this.field_21031_b.add(new ChunkPosition(i2, j2, k2 - 1));
                this.field_21031_b.add(new ChunkPosition(i2, j2, k2 + 1));
            }
        }
    }

    private void notifyWireNeighborsOfNeighborChange(World world, int i2, int j2, int k2) {
        if (world.getBlockId(i2, j2, k2) != this.blockID) {
            return;
        }
        world.notifyBlocksOfNeighborChange(i2, j2, k2, this.blockID);
        world.notifyBlocksOfNeighborChange(i2 - 1, j2, k2, this.blockID);
        world.notifyBlocksOfNeighborChange(i2 + 1, j2, k2, this.blockID);
        world.notifyBlocksOfNeighborChange(i2, j2, k2 - 1, this.blockID);
        world.notifyBlocksOfNeighborChange(i2, j2, k2 + 1, this.blockID);
        world.notifyBlocksOfNeighborChange(i2, j2 - 1, k2, this.blockID);
        world.notifyBlocksOfNeighborChange(i2, j2 + 1, k2, this.blockID);
    }

    @Override
    public void onBlockAdded(World world, int i2, int j2, int k2) {
        super.onBlockAdded(world, i2, j2, k2);
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        this.updateAndPropagateCurrentStrength(world, i2, j2, k2);
        world.notifyBlocksOfNeighborChange(i2, j2 + 1, k2, this.blockID);
        world.notifyBlocksOfNeighborChange(i2, j2 - 1, k2, this.blockID);
        this.notifyWireNeighborsOfNeighborChange(world, i2 - 1, j2, k2);
        this.notifyWireNeighborsOfNeighborChange(world, i2 + 1, j2, k2);
        this.notifyWireNeighborsOfNeighborChange(world, i2, j2, k2 - 1);
        this.notifyWireNeighborsOfNeighborChange(world, i2, j2, k2 + 1);
        if (world.isBlockNormalCube(i2 - 1, j2, k2)) {
            this.notifyWireNeighborsOfNeighborChange(world, i2 - 1, j2 + 1, k2);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i2 - 1, j2 - 1, k2);
        }
        if (world.isBlockNormalCube(i2 + 1, j2, k2)) {
            this.notifyWireNeighborsOfNeighborChange(world, i2 + 1, j2 + 1, k2);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i2 + 1, j2 - 1, k2);
        }
        if (world.isBlockNormalCube(i2, j2, k2 - 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, i2, j2 + 1, k2 - 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i2, j2 - 1, k2 - 1);
        }
        if (world.isBlockNormalCube(i2, j2, k2 + 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, i2, j2 + 1, k2 + 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i2, j2 - 1, k2 + 1);
        }
    }

    @Override
    public void onBlockRemoval(World world, int i2, int j2, int k2) {
        super.onBlockRemoval(world, i2, j2, k2);
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        world.notifyBlocksOfNeighborChange(i2, j2 + 1, k2, this.blockID);
        world.notifyBlocksOfNeighborChange(i2, j2 - 1, k2, this.blockID);
        this.updateAndPropagateCurrentStrength(world, i2, j2, k2);
        this.notifyWireNeighborsOfNeighborChange(world, i2 - 1, j2, k2);
        this.notifyWireNeighborsOfNeighborChange(world, i2 + 1, j2, k2);
        this.notifyWireNeighborsOfNeighborChange(world, i2, j2, k2 - 1);
        this.notifyWireNeighborsOfNeighborChange(world, i2, j2, k2 + 1);
        if (world.isBlockNormalCube(i2 - 1, j2, k2)) {
            this.notifyWireNeighborsOfNeighborChange(world, i2 - 1, j2 + 1, k2);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i2 - 1, j2 - 1, k2);
        }
        if (world.isBlockNormalCube(i2 + 1, j2, k2)) {
            this.notifyWireNeighborsOfNeighborChange(world, i2 + 1, j2 + 1, k2);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i2 + 1, j2 - 1, k2);
        }
        if (world.isBlockNormalCube(i2, j2, k2 - 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, i2, j2 + 1, k2 - 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i2, j2 - 1, k2 - 1);
        }
        if (world.isBlockNormalCube(i2, j2, k2 + 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, i2, j2 + 1, k2 + 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i2, j2 - 1, k2 + 1);
        }
    }

    private int getMaxCurrentStrength(World world, int i2, int j2, int k2, int l2) {
        if (world.getBlockId(i2, j2, k2) != this.blockID) {
            return l2;
        }
        int i1 = world.getBlockMetadata(i2, j2, k2);
        if (i1 > l2) {
            return i1;
        }
        return l2;
    }

    @Override
    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        int i1 = world.getBlockMetadata(i2, j2, k2);
        boolean flag = this.canPlaceBlockAt(world, i2, j2, k2);
        if (!flag) {
            this.dropBlockAsItem(world, i2, j2, k2, i1);
            world.setBlockWithNotify(i2, j2, k2, 0);
        } else {
            this.updateAndPropagateCurrentStrength(world, i2, j2, k2);
        }
        super.onNeighborBlockChange(world, i2, j2, k2, l2);
    }

    @Override
    public int idDropped(int i2, Random random) {
        return Item.dustRedstone.itemID;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int i2, int j2, int k2, int l2) {
        if (!this.wiresProvidePower) {
            return false;
        }
        return this.isPoweringTo(world, i2, j2, k2, l2);
    }

    @Override
    public boolean isPoweringTo(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        boolean flag3;
        if (!this.wiresProvidePower) {
            return false;
        }
        if (iblockaccess.getBlockMetadata(i2, j2, k2) == 0) {
            return false;
        }
        if (l2 == 1) {
            return true;
        }
        boolean flag = BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i2 - 1, j2, k2, 1) || !iblockaccess.isBlockNormalCube(i2 - 1, j2, k2) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i2 - 1, j2 - 1, k2, -1);
        boolean flag1 = BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i2 + 1, j2, k2, 3) || !iblockaccess.isBlockNormalCube(i2 + 1, j2, k2) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i2 + 1, j2 - 1, k2, -1);
        boolean flag2 = BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i2, j2, k2 - 1, 2) || !iblockaccess.isBlockNormalCube(i2, j2, k2 - 1) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i2, j2 - 1, k2 - 1, -1);
        boolean bl2 = flag3 = BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i2, j2, k2 + 1, 0) || !iblockaccess.isBlockNormalCube(i2, j2, k2 + 1) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i2, j2 - 1, k2 + 1, -1);
        if (!iblockaccess.isBlockNormalCube(i2, j2 + 1, k2)) {
            if (iblockaccess.isBlockNormalCube(i2 - 1, j2, k2) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i2 - 1, j2 + 1, k2, -1)) {
                flag = true;
            }
            if (iblockaccess.isBlockNormalCube(i2 + 1, j2, k2) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i2 + 1, j2 + 1, k2, -1)) {
                flag1 = true;
            }
            if (iblockaccess.isBlockNormalCube(i2, j2, k2 - 1) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i2, j2 + 1, k2 - 1, -1)) {
                flag2 = true;
            }
            if (iblockaccess.isBlockNormalCube(i2, j2, k2 + 1) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i2, j2 + 1, k2 + 1, -1)) {
                flag3 = true;
            }
        }
        if (!(flag2 || flag1 || flag || flag3 || l2 < 2 || l2 > 5)) {
            return true;
        }
        if (l2 == 2 && flag2 && !flag && !flag1) {
            return true;
        }
        if (l2 == 3 && flag3 && !flag && !flag1) {
            return true;
        }
        if (l2 == 4 && flag && !flag2 && !flag3) {
            return true;
        }
        return l2 == 5 && flag1 && !flag2 && !flag3;
    }

    @Override
    public boolean canProvidePower() {
        return this.wiresProvidePower;
    }

    @Override
    public void randomDisplayTick(World world, int i2, int j2, int k2, Random random) {
        int l2 = world.getBlockMetadata(i2, j2, k2);
        if (l2 > 0) {
            double d2 = (double)i2 + 0.5 + ((double)random.nextFloat() - 0.5) * 0.2;
            double d1 = (float)j2 + 0.0625f;
            double d22 = (double)k2 + 0.5 + ((double)random.nextFloat() - 0.5) * 0.2;
            float f2 = (float)l2 / 15.0f;
            float f1 = f2 * 0.6f + 0.4f;
            if (l2 == 0) {
                f1 = 0.0f;
            }
            float f22 = f2 * f2 * 0.7f - 0.5f;
            float f3 = f2 * f2 * 0.6f - 0.7f;
            if (f22 < 0.0f) {
                f22 = 0.0f;
            }
            if (f3 < 0.0f) {
                f3 = 0.0f;
            }
            world.spawnParticle("reddust", d2, d1, d22, f1, f22, f3);
        }
    }

    public static boolean isPowerProviderOrWire(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        int i1 = iblockaccess.getBlockId(i2, j2, k2);
        if (i1 == Block.wireRedstone.blockID) {
            return true;
        }
        if (i1 == 0) {
            return false;
        }
        if (Block.blocksList[i1].canProvidePower()) {
            return true;
        }
        if (i1 == Block.repeaterIdle.blockID || i1 == Block.repeaterActive.blockID) {
            int j1 = iblockaccess.getBlockMetadata(i2, j2, k2);
            return l2 == ModelBed.field_22279_b[j1 & 3];
        }
        return false;
    }
}

