/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.Material;
import net.minecraft.src.Sides;
import net.minecraft.src.World;
import net.minecraft.src.helper.Direction;

public abstract class BlockRotatable
extends Block {
    public BlockRotatable(int i2, Material material) {
        super(i2, material);
    }

    public void setDefaultDirection(World world, int i2, int j2, int k2) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        int l2 = world.getBlockId(i2, j2, k2 - 1);
        int i1 = world.getBlockId(i2, j2, k2 + 1);
        int j1 = world.getBlockId(i2 - 1, j2, k2);
        int k1 = world.getBlockId(i2 + 1, j2, k2);
        int byte0 = 3;
        if (Block.opaqueCubeLookup[l2] && !Block.opaqueCubeLookup[i1]) {
            byte0 = 3;
        }
        if (Block.opaqueCubeLookup[i1] && !Block.opaqueCubeLookup[l2]) {
            byte0 = 2;
        }
        if (Block.opaqueCubeLookup[j1] && !Block.opaqueCubeLookup[k1]) {
            byte0 = 5;
        }
        if (Block.opaqueCubeLookup[k1] && !Block.opaqueCubeLookup[j1]) {
            byte0 = 4;
        }
        world.setBlockMetadataWithNotify(i2, j2, k2, byte0);
    }

    @Override
    public void onBlockPlaced(World world, int x2, int y2, int z2, Direction side, EntityLiving player, double sideHeight) {
        int l2 = player.getHorizontalPlacementDirection((Direction)side).index;
        if (l2 == 0) {
            world.setBlockMetadataWithNotify(x2, y2, z2, 2);
        }
        if (l2 == 1) {
            world.setBlockMetadataWithNotify(x2, y2, z2, 5);
        }
        if (l2 == 2) {
            world.setBlockMetadataWithNotify(x2, y2, z2, 3);
        }
        if (l2 == 3) {
            world.setBlockMetadataWithNotify(x2, y2, z2, 4);
        }
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int side, int meta) {
        int index = Sides.orientationLookUp[6 * meta + side];
        return this.atlasIndices[index];
    }

    @Override
    public void onBlockAdded(World world, int i2, int j2, int k2) {
        super.onBlockAdded(world, i2, j2, k2);
        this.setDefaultDirection(world, i2, j2, k2);
    }
}

