/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFlower;
import net.minecraft.src.MathHelper;
import net.minecraft.src.World;

public abstract class BlockSaplingBase
extends BlockFlower {
    public BlockSaplingBase(int i2) {
        super(i2);
        float f2 = 0.4f;
        this.setBlockBounds(0.5f - f2, 0.0f, 0.5f - f2, 0.5f + f2, f2 * 2.0f, 0.5f + f2);
    }

    @Override
    public boolean canThisPlantGrowOnThisBlockID(int i2) {
        return i2 == Block.sand.blockID || super.canThisPlantGrowOnThisBlockID(i2);
    }

    @Override
    public void updateTick(World world, int i2, int j2, int k2, Random random) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        if (world.getBlockId(i2, j2 - 1, k2) == Block.sand.blockID) {
            world.setBlockWithNotify(i2, j2, k2, Block.deadbush.blockID);
        }
        super.updateTick(world, i2, j2, k2, random);
        int growthRate = 30;
        if (world.currentSeason != null) {
            growthRate = MathHelper.floor_float((float)growthRate / world.currentSeason.cropGrowthFactor);
        }
        if (world.getBlockLightValue(i2, j2 + 1, k2) >= 9 && random.nextInt(growthRate) == 0) {
            int l2 = world.getBlockMetadata(i2, j2, k2);
            if ((l2 & 8) == 0) {
                world.setBlockMetadataWithNotify(i2, j2, k2, l2 | 8);
            } else {
                this.growTree(world, i2, j2, k2, random);
            }
        }
    }

    public abstract void growTree(World var1, int var2, int var3, int var4, Random var5);
}

