/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockSaplingBase;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenTreeShapeTaigaBushy;
import net.minecraft.src.WorldGenTreeShapeTaigaTall;
import net.minecraft.src.WorldGenerator;

public class BlockSaplingPine
extends BlockSaplingBase {
    public BlockSaplingPine(int i2) {
        super(i2);
    }

    @Override
    public void updateTick(World world, int i2, int j2, int k2, Random random) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        super.updateTick(world, i2, j2, k2, random);
        int growthRate = 30;
        if (world.getBlockLightValue(i2, j2 + 1, k2) >= 9 && random.nextInt(growthRate) == 0) {
            int l2 = world.getBlockMetadata(i2, j2, k2);
            if ((l2 & 8) == 0) {
                world.setBlockMetadataWithNotify(i2, j2, k2, l2 | 8);
            } else {
                this.growTree(world, i2, j2, k2, random);
            }
        }
    }

    @Override
    public void growTree(World world, int i2, int j2, int k2, Random random) {
        WorldGenTreeShapeTaigaTall treeBig = new WorldGenTreeShapeTaigaTall(Block.leavesPine.blockID, Block.logPine.blockID);
        WorldGenTreeShapeTaigaBushy treeSmall = new WorldGenTreeShapeTaigaBushy(Block.leavesPine.blockID, Block.logPine.blockID);
        world.setBlock(i2, j2, k2, 0);
        if (!((WorldGenerator)treeSmall).generate(world, random, i2, j2, k2) && !((WorldGenerator)treeBig).generate(world, random, i2, j2, k2)) {
            world.setBlock(i2, j2, k2, this.blockID);
        }
    }
}

