/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainerRotatable;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntitySensor;
import net.minecraft.src.World;

public class BlockSensor
extends BlockContainerRotatable {
    private boolean isActive;

    public BlockSensor(int i2, boolean isActive) {
        super(i2, Material.glass);
        this.isActive = isActive;
    }

    @Override
    public int getBlockOverbright(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        if (!this.isActive) {
            return -1;
        }
        int i1 = iblockaccess.getBlockMetadata(i2, j2, k2);
        if (l2 == i1) {
            return BlockSensor.texCoordToIndex(1, 16);
        }
        return -1;
    }

    @Override
    public void onBlockAdded(World world, int i2, int j2, int k2) {
        super.onBlockAdded(world, i2, j2, k2);
        this.setDefaultDirection(world, i2, j2, k2);
    }

    @Override
    public void randomDisplayTick(World world, int i2, int j2, int k2, Random random) {
        if (!this.isActive) {
            return;
        }
        BlockSensor.spawnParticles(world, i2, j2, k2);
    }

    public static void updateSensorBlockState(boolean flag, World world, int x2, int y2, int z2) {
        int l2 = world.getBlockMetadata(x2, y2, z2);
        if (flag) {
            world.setBlockWithNotify(x2, y2, z2, Block.motionsensorActive.blockID);
        }
        if (!flag) {
            world.setBlockWithNotify(x2, y2, z2, Block.motionsensorIdle.blockID);
        }
        world.setBlockMetadataWithNotify(x2, y2, z2, l2);
    }

    @Override
    public void onBlockRemoval(World world, int i2, int j2, int k2) {
        super.onBlockRemoval(world, i2, j2, k2);
    }

    private static void spawnParticles(World world, int i2, int j2, int k2) {
        Random random = world.rand;
        double d2 = 0.0625;
        for (int l2 = 0; l2 < 6; ++l2) {
            double d1 = (float)i2 + random.nextFloat();
            double d22 = (float)j2 + random.nextFloat();
            double d3 = (float)k2 + random.nextFloat();
            if (l2 == 0 && !world.isBlockOpaqueCube(i2, j2 + 1, k2)) {
                d22 = (double)(j2 + 1) + d2;
            }
            if (l2 == 1 && !world.isBlockOpaqueCube(i2, j2 - 1, k2)) {
                d22 = (double)j2 - d2;
            }
            if (l2 == 2 && !world.isBlockOpaqueCube(i2, j2, k2 + 1)) {
                d3 = (double)(k2 + 1) + d2;
            }
            if (l2 == 3 && !world.isBlockOpaqueCube(i2, j2, k2 - 1)) {
                d3 = (double)k2 - d2;
            }
            if (l2 == 4 && !world.isBlockOpaqueCube(i2 + 1, j2, k2)) {
                d1 = (double)(i2 + 1) + d2;
            }
            if (l2 == 5 && !world.isBlockOpaqueCube(i2 - 1, j2, k2)) {
                d1 = (double)i2 - d2;
            }
            if (!(d1 < (double)i2 || d1 > (double)(i2 + 1) || d22 < 0.0 || d22 > (double)(j2 + 1) || d3 < (double)k2) && !(d3 > (double)(k2 + 1))) continue;
            world.spawnParticle("reddust", d1, d22, d3, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int i2, int j2, int k2, int l2) {
        return this.isPoweringTo(world, i2, j2, k2, l2);
    }

    @Override
    public boolean isPoweringTo(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        return this.isActive;
    }

    @Override
    public int idDropped(int i2, Random random) {
        return Block.motionsensorIdle.blockID;
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntitySensor();
    }
}

