/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import net.minecraft.src.helper.Direction;

public class BlockSlab
extends Block {
    private Block modelBlock;
    private int modelBlockMetadata;

    public BlockSlab(int id2, Block modelBlock) {
        this(id2, modelBlock, 0);
    }

    public BlockSlab(int id2, Block modelBlock, int modelBlockMetadata) {
        super(id2, modelBlock.blockMaterial);
        this.atlasIndices = modelBlock.atlasIndices;
        this.modelBlock = modelBlock;
        this.modelBlockMetadata = modelBlockMetadata;
        this.setHardness(modelBlock.blockHardness);
        this.setResistance(modelBlock.blockResistance / 3.0f);
        this.setStepSound(modelBlock.stepSound);
        this.setLightValue(lightValue[modelBlock.blockID]);
        this.setLightOpacity(1);
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int i2, int j2, int k2) {
        int l2 = world.getBlockMetadata(i2, j2, k2) & 3;
        if (l2 == 0) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        } else if (l2 == 1) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else if (l2 == 2) {
            this.setBlockBounds(0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        int l2 = world.getBlockMetadata(i2, j2, k2) & 3;
        if (l2 == 0) {
            return AxisAlignedBB.getBoundingBoxFromPool(i2, j2, k2, (float)i2 + 1.0f, (float)j2 + 0.5f, (float)k2 + 1.0f);
        }
        if (l2 == 1) {
            return AxisAlignedBB.getBoundingBoxFromPool(i2, j2, k2, i2 + 1, (float)j2 + 1.0f, (float)k2 + 1.0f);
        }
        return AxisAlignedBB.getBoundingBoxFromPool(i2, (float)j2 + 0.5f, k2, (float)i2 + 1.0f, (float)j2 + 1.0f, (float)k2 + 1.0f);
    }

    @Override
    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlockOnCondition(World world, int x2, int y2, int z2) {
        int meta = world.getBlockMetadata(x2, y2, z2);
        return (meta & 3) == 1;
    }

    @Override
    public boolean canPlaceOnSurfaceOnCondition(World world, int x2, int y2, int z2) {
        int meta = world.getBlockMetadata(x2, y2, z2);
        return (meta & 3) != 0;
    }

    @Override
    public void dropBlockWhenCrushed(World world, int i2, int j2, int k2, int l2) {
        if ((l2 & 3) == 1) {
            world.dropItem(i2, j2, k2, new ItemStack(this.blockID, 2, l2 & 0xF0));
        } else {
            world.dropItem(i2, j2, k2, new ItemStack(this.blockID, 1, l2 & 0xF0));
        }
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i2, int j2) {
        return this.modelBlock.getBlockTextureFromSideAndMetadata(i2, this.modelBlockMetadata);
    }

    @Override
    public int getBlockTextureFromSide(int i2) {
        return this.modelBlock.getBlockTextureFromSide(i2);
    }

    @Override
    public int getBlockTexture(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        return this.modelBlock.getBlockTextureFromSideAndMetadata(l2, this.modelBlockMetadata);
    }

    @Override
    public int tickRate() {
        return this.modelBlock.tickRate();
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        return this.getCollisionBoundingBoxFromPool(world, i2, j2, k2);
    }

    @Override
    public void velocityToAddToEntity(World world, int i2, int j2, int k2, Entity entity, Vec3D vec3d) {
        this.modelBlock.velocityToAddToEntity(world, i2, j2, k2, entity, vec3d);
    }

    @Override
    public boolean isCollidable() {
        return this.modelBlock.isCollidable();
    }

    @Override
    public boolean canCollideCheck(int i2, boolean flag) {
        return this.modelBlock.canCollideCheck(i2, flag);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i2, int j2, int k2) {
        return world.getBlockId(i2, j2 - 1, k2) == this.blockID || world.getBlockId(i2, j2 + 1, k2) == this.blockID || super.canPlaceBlockAt(world, i2, j2, k2);
    }

    @Override
    public void onEntityWalking(World world, int i2, int j2, int k2, Entity entity) {
        this.modelBlock.onEntityWalking(world, i2, j2, k2, entity);
    }

    @Override
    public void updateTick(World world, int i2, int j2, int k2, Random random) {
        this.modelBlock.updateTick(world, i2, j2, k2, random);
    }

    @Override
    public boolean blockActivated(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        return this.modelBlock.blockActivated(world, i2, j2, k2, entityplayer);
    }

    @Override
    public void onBlockDestroyedByExplosion(World world, int i2, int j2, int k2) {
        this.modelBlock.onBlockDestroyedByExplosion(world, i2, j2, k2);
    }

    @Override
    public void onBlockPlaced(World world, int x2, int y2, int z2, Direction side, EntityLiving player, double sideHeight) {
        Direction dir = player.getVerticalPlacementDirection(side, sideHeight);
        if (dir == Direction.DOWN) {
            world.setBlockMetadataWithNotify(x2, y2, z2, 0);
        }
        if (dir == Direction.UP) {
            world.setBlockMetadataWithNotify(x2, y2, z2, 2);
        }
    }

    @Override
    public void onBlockAdded(World world, int i2, int j2, int k2) {
        this.onNeighborBlockChange(world, i2, j2, k2, 0);
        this.modelBlock.onBlockAdded(world, i2, j2, k2);
    }

    @Override
    public int getRenderBlockPass() {
        return this.modelBlock.getRenderBlockPass();
    }

    @Override
    public float getExplosionResistance(Entity entity) {
        return this.modelBlock.getExplosionResistance(entity);
    }

    @Override
    public float getBlockBrightness(IBlockAccess iblockaccess, int i2, int j2, int k2) {
        return this.modelBlock.getBlockBrightness(iblockaccess, i2, j2, k2);
    }

    @Override
    public void onBlockDestroyedByPlayer(World world, int i2, int j2, int k2, int l2) {
        this.modelBlock.onBlockDestroyedByPlayer(world, i2, j2, k2, this.modelBlockMetadata);
    }

    @Override
    public void onBlockClicked(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        this.modelBlock.onBlockClicked(world, i2, j2, k2, entityplayer);
    }

    @Override
    public void randomDisplayTick(World world, int i2, int j2, int k2, Random random) {
        this.modelBlock.randomDisplayTick(world, i2, j2, k2, random);
    }

    @Override
    protected int damageDropped(int damage) {
        return 0;
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return (metadata & 3) == 1 ? 2 : 1;
    }
}

