/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.BlockSlab;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.World;
import net.minecraft.src.helper.Direction;

public class BlockSlabPainted
extends BlockSlab {
    public BlockSlabPainted(int id2, Block modelBlock) {
        super(id2, modelBlock);
    }

    @Override
    public int getRenderColor(int i2) {
        return Block.planksOakPainted.getRenderColor((i2 & 0xF0) >> 4);
    }

    @Override
    public int colorMultiplier(World world, IBlockAccess iblockaccess, int i2, int j2, int k2) {
        int meta = world.getBlockMetadata(i2, j2, k2);
        return this.getRenderColor(meta);
    }

    @Override
    protected int damageDropped(int i2) {
        return i2 & 0xF0;
    }

    public static int getMetadataForColour(int i2) {
        return ~i2 << 4 & 0xF0;
    }

    @Override
    public void onBlockPlaced(World world, int x2, int y2, int z2, Direction side, EntityLiving player, double sideHeight) {
        int meta = player.getVerticalPlacementDirection(side, sideHeight) == Direction.UP ? 2 : 0;
        world.setBlockMetadataWithNotify(x2, y2, z2, meta | world.getBlockMetadata(x2, y2, z2) & 0xF0);
    }
}

