/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockWeb;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Material;
import net.minecraft.src.World;
import net.minecraft.src.helper.DamageType;

public class BlockSpikes
extends BlockWeb {
    public BlockSpikes(int i2, Material mat) {
        super(i2, mat);
    }

    @Override
    public int getRenderType() {
        return 19;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i2, int j2, int k2) {
        return world.canPlaceOnSurfaceOfBlock(i2, j2 - 1, k2) || world.getBlockId(i2, j2 - 1, k2) == Block.mobspawner.blockID;
    }

    @Override
    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        boolean flag;
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        boolean bl2 = flag = !world.canPlaceOnSurfaceOfBlock(i2, j2 - 1, k2) && world.getBlockId(i2, j2 - 1, k2) != Block.mesh.blockID && world.getBlockId(i2, j2 - 1, k2) != Block.mobspawner.blockID;
        if (flag) {
            this.dropBlockAsItem(world, i2, j2, k2, world.getBlockMetadata(i2, j2, k2));
            world.setBlockWithNotify(i2, j2, k2, 0);
        }
        if (l2 > 0 && Block.blocksList[l2].canProvidePower()) {
            boolean isPowered = world.isBlockIndirectlyGettingPowered(i2, j2, k2);
            this.onPoweredBlockChange(world, i2, j2, k2, isPowered);
        }
    }

    public void onPoweredBlockChange(World world, int i2, int j2, int k2, boolean isPowered) {
        boolean flag1;
        int l2 = world.getBlockMetadata(i2, j2, k2);
        boolean bl2 = flag1 = (l2 & 1) > 0;
        if (flag1 == isPowered) {
            return;
        }
        world.setBlockMetadataWithNotify(i2, j2, k2, l2 ^ 1);
        if ((l2 & 1) < 1) {
            world.playSoundEffectForPlayer(null, 1006, i2, j2, k2, 0);
        } else {
            world.playSoundEffectForPlayer(null, 1007, i2, j2, k2, 0);
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x2, int y2, int z2) {
        float f2 = 0.0625f;
        return AxisAlignedBB.getBoundingBoxFromPool((float)x2 + f2, y2, (float)z2 + f2, (float)(x2 + 1) - f2, (float)y2 + 0.1875f, (float)(z2 + 1) - f2);
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int i2, int j2, int k2, Entity entity) {
        int metaData = world.getBlockMetadata(i2, j2, k2);
        if (BlockSpikes.isSpikesUp(metaData) && entity instanceof EntityLiving) {
            if (entity instanceof EntityPlayer && entity.isSneaking()) {
                return;
            }
            entity.attackEntityFrom(null, 5, DamageType.COMBAT);
            entity.isInWeb = true;
        }
    }

    @Override
    public int idDropped(int i2, Random random) {
        return this.blockID;
    }

    public static boolean isSpikesUp(int i2) {
        return (i2 & 1) != 1;
    }
}

