/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.Dimension;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockSponge
extends Block {
    boolean isWet;

    public BlockSponge(int i2, boolean isWet) {
        super(i2, Material.sponge);
        this.isWet = isWet;
    }

    @Override
    public void onBlockAdded(World world, int i2, int j2, int k2) {
        int l2;
        super.onBlockAdded(world, i2, j2, k2);
        int byte0 = 2;
        if (world.dimension.dimId == Dimension.nether.dimId && this.isWet) {
            world.setBlockWithNotify(i2, j2, k2, Block.spongeDry.blockID);
            world.playSoundEffect((double)i2 + 0.5, (double)j2 + 0.5, (double)k2 + 0.5, "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
            for (l2 = 0; l2 < 8; ++l2) {
                world.spawnParticle("largesmoke", (double)i2 + Math.random(), (double)j2 + Math.random(), (double)k2 + Math.random(), 0.0, 0.0, 0.0);
            }
        }
        if (!this.isWet && this.inWater(world, i2, j2, k2)) {
            for (l2 = i2 - byte0; l2 <= i2 + byte0; ++l2) {
                for (int i1 = j2 - byte0; i1 <= j2 + byte0; ++i1) {
                    for (int j1 = k2 - byte0; j1 <= k2 + byte0; ++j1) {
                        if (world.getBlockMaterial(l2, i1, j1) != Material.water) continue;
                        world.setBlockWithNotify(l2, i1, j1, 0);
                    }
                }
            }
        }
    }

    public boolean inWater(World world, int x2, int y2, int z2) {
        if (world.getBlockMaterial(x2 + 1, y2, z2) == Material.water) {
            return true;
        }
        if (world.getBlockMaterial(x2 - 1, y2, z2) == Material.water) {
            return true;
        }
        if (world.getBlockMaterial(x2, y2 + 1, z2) == Material.water) {
            return true;
        }
        if (world.getBlockMaterial(x2, y2 - 1, z2) == Material.water) {
            return true;
        }
        if (world.getBlockMaterial(x2, y2, z2 + 1) == Material.water) {
            return true;
        }
        return world.getBlockMaterial(x2, y2, z2 - 1) == Material.water;
    }

    @Override
    public void onBlockRemoval(World world, int i2, int j2, int k2) {
        if (!this.isWet) {
            int byte0 = 2;
            for (int l2 = i2 - byte0; l2 <= i2 + byte0; ++l2) {
                for (int i1 = j2 - byte0; i1 <= j2 + byte0; ++i1) {
                    for (int j1 = k2 - byte0; j1 <= k2 + byte0; ++j1) {
                        world.notifyBlocksOfNeighborChange(l2, i1, j1, world.getBlockId(l2, i1, j1));
                    }
                }
            }
        }
    }
}

