/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import net.minecraft.src.helper.Direction;

public class BlockStairs
extends Block {
    private Block modelBlock;

    public BlockStairs(int i2, Block block) {
        super(i2, block.blockMaterial);
        this.modelBlock = block;
        this.atlasIndices = block.atlasIndices;
        this.setHardness(block.blockHardness);
        this.setResistance(block.blockResistance / 3.0f);
        this.setStepSound(block.stepSound);
        this.setLightOpacity(255);
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int i2, int j2, int k2) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        return super.getCollisionBoundingBoxFromPool(world, i2, j2, k2);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 10;
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        return super.shouldSideBeRendered(iblockaccess, i2, j2, k2, l2);
    }

    @Override
    public void getCollidingBoundingBoxes(World world, int i2, int j2, int k2, AxisAlignedBB axisalignedbb, ArrayList arraylist) {
        int l2 = world.getBlockMetadata(i2, j2, k2) & 3;
        if (l2 == 0) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 1.0f);
            super.getCollidingBoundingBoxes(world, i2, j2, k2, axisalignedbb, arraylist);
            this.setBlockBounds(0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            super.getCollidingBoundingBoxes(world, i2, j2, k2, axisalignedbb, arraylist);
        } else if (l2 == 1) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f);
            super.getCollidingBoundingBoxes(world, i2, j2, k2, axisalignedbb, arraylist);
            this.setBlockBounds(0.5f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
            super.getCollidingBoundingBoxes(world, i2, j2, k2, axisalignedbb, arraylist);
        } else if (l2 == 2) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 0.5f);
            super.getCollidingBoundingBoxes(world, i2, j2, k2, axisalignedbb, arraylist);
            this.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f);
            super.getCollidingBoundingBoxes(world, i2, j2, k2, axisalignedbb, arraylist);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
            super.getCollidingBoundingBoxes(world, i2, j2, k2, axisalignedbb, arraylist);
            this.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 0.5f, 1.0f);
            super.getCollidingBoundingBoxes(world, i2, j2, k2, axisalignedbb, arraylist);
        }
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void randomDisplayTick(World world, int i2, int j2, int k2, Random random) {
        this.modelBlock.randomDisplayTick(world, i2, j2, k2, random);
    }

    @Override
    public void onBlockClicked(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        this.modelBlock.onBlockClicked(world, i2, j2, k2, entityplayer);
    }

    @Override
    public void onBlockDestroyedByPlayer(World world, int i2, int j2, int k2, int l2) {
        this.modelBlock.onBlockDestroyedByPlayer(world, i2, j2, k2, l2);
    }

    @Override
    public float getBlockBrightness(IBlockAccess iblockaccess, int i2, int j2, int k2) {
        return this.modelBlock.getBlockBrightness(iblockaccess, i2, j2, k2);
    }

    @Override
    public float getExplosionResistance(Entity entity) {
        return this.modelBlock.getExplosionResistance(entity);
    }

    @Override
    public int getRenderBlockPass() {
        return this.modelBlock.getRenderBlockPass();
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return this.modelBlock.quantityDropped(metadata, random);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i2, int j2) {
        return this.modelBlock.getBlockTextureFromSideAndMetadata(i2, j2);
    }

    @Override
    public int getBlockTextureFromSide(int i2) {
        return this.modelBlock.getBlockTextureFromSide(i2);
    }

    @Override
    public int getBlockTexture(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        return this.modelBlock.getBlockTexture(iblockaccess, i2, j2, k2, l2);
    }

    @Override
    public int tickRate() {
        return this.modelBlock.tickRate();
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        return this.modelBlock.getSelectedBoundingBoxFromPool(world, i2, j2, k2);
    }

    @Override
    public void velocityToAddToEntity(World world, int i2, int j2, int k2, Entity entity, Vec3D vec3d) {
        this.modelBlock.velocityToAddToEntity(world, i2, j2, k2, entity, vec3d);
    }

    @Override
    public boolean isCollidable() {
        return this.modelBlock.isCollidable();
    }

    @Override
    public boolean canCollideCheck(int i2, boolean flag) {
        return this.modelBlock.canCollideCheck(i2, flag);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i2, int j2, int k2) {
        return this.modelBlock.canPlaceBlockAt(world, i2, j2, k2);
    }

    @Override
    public void onBlockAdded(World world, int i2, int j2, int k2) {
        this.onNeighborBlockChange(world, i2, j2, k2, 0);
        this.modelBlock.onBlockAdded(world, i2, j2, k2);
    }

    @Override
    public void onEntityWalking(World world, int i2, int j2, int k2, Entity entity) {
        this.modelBlock.onEntityWalking(world, i2, j2, k2, entity);
    }

    @Override
    public void updateTick(World world, int i2, int j2, int k2, Random random) {
        this.modelBlock.updateTick(world, i2, j2, k2, random);
    }

    @Override
    public boolean blockActivated(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        return this.modelBlock.blockActivated(world, i2, j2, k2, entityplayer);
    }

    @Override
    public void onBlockDestroyedByExplosion(World world, int i2, int j2, int k2) {
        this.modelBlock.onBlockDestroyedByExplosion(world, i2, j2, k2);
    }

    @Override
    public void onBlockPlaced(World world, int x2, int y2, int z2, Direction side, EntityLiving player, double sideHeight) {
        int rotation = player.getHorizontalPlacementDirection(side).getIndex();
        if (rotation == 0) {
            world.setBlockMetadataWithNotify(x2, y2, z2, 2 | world.getBlockMetadata(x2, y2, z2) & 0xF0);
        }
        if (rotation == 1) {
            world.setBlockMetadataWithNotify(x2, y2, z2, 1 | world.getBlockMetadata(x2, y2, z2) & 0xF0);
        }
        if (rotation == 2) {
            world.setBlockMetadataWithNotify(x2, y2, z2, 3 | world.getBlockMetadata(x2, y2, z2) & 0xF0);
        }
        if (rotation == 3) {
            world.setBlockMetadataWithNotify(x2, y2, z2, 0 | world.getBlockMetadata(x2, y2, z2) & 0xF0);
        }
    }
}

