/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Item;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockSugarcane
extends Block {
    public BlockSugarcane(int i2) {
        super(i2, Material.plants);
        float f2 = 0.375f;
        this.setBlockBounds(0.5f - f2, 0.0f, 0.5f - f2, 0.5f + f2, 1.0f, 0.5f + f2);
        this.setTickOnLoad(true);
    }

    @Override
    public void updateTick(World world, int x2, int y2, int z2, Random random) {
        if (world.isAirBlock(x2, y2 + 1, z2)) {
            int l2 = 1;
            while (world.getBlockId(x2, y2 - l2, z2) == this.blockID) {
                ++l2;
            }
            if (l2 < 3) {
                int i1 = world.getBlockMetadata(x2, y2, z2);
                if (i1 == 15) {
                    world.setBlockWithNotify(x2, y2 + 1, z2, this.blockID);
                    world.setBlockMetadataWithNotify(x2, y2, z2, 0);
                } else {
                    world.setBlockMetadataWithNotify(x2, y2, z2, i1 + 1);
                }
            }
        }
    }

    public void growReedOnTop(World world, int x2, int y2, int z2) {
        int l2 = 1;
        while (world.getBlockId(x2, y2 + l2, z2) == this.blockID) {
            ++l2;
        }
        if (world.isAirBlock(x2, y2 + l2, z2)) {
            world.setBlockWithNotify(x2, y2 + l2, z2, this.blockID);
        }
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i2, int j2, int k2) {
        int l2 = world.getBlockId(i2, j2 - 1, k2);
        if (l2 == this.blockID) {
            return true;
        }
        if (Block.blocksList[l2] == null || !Block.blocksList[l2].plantable) {
            return false;
        }
        if (world.getBlockMaterial(i2 - 1, j2 - 1, k2) == Material.water) {
            return true;
        }
        if (world.getBlockMaterial(i2 + 1, j2 - 1, k2) == Material.water) {
            return true;
        }
        if (world.getBlockMaterial(i2, j2 - 1, k2 - 1) == Material.water) {
            return true;
        }
        return world.getBlockMaterial(i2, j2 - 1, k2 + 1) == Material.water;
    }

    @Override
    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        this.checkBlockCoordValid(world, i2, j2, k2);
    }

    protected final void checkBlockCoordValid(World world, int i2, int j2, int k2) {
        if (!this.canBlockStay(world, i2, j2, k2)) {
            this.dropBlockAsItem(world, i2, j2, k2, world.getBlockMetadata(i2, j2, k2));
            world.setBlockWithNotify(i2, j2, k2, 0);
        }
    }

    @Override
    public boolean canBlockStay(World world, int i2, int j2, int k2) {
        return this.canPlaceBlockAt(world, i2, j2, k2);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        return null;
    }

    @Override
    public int idDropped(int i2, Random random) {
        return Item.sugarcane.itemID;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 1;
    }
}

