/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityTNTPrimed;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockTNT
extends Block {
    public BlockTNT(int i2) {
        super(i2, Material.tnt);
    }

    @Override
    public void onBlockAdded(World world, int i2, int j2, int k2) {
        super.onBlockAdded(world, i2, j2, k2);
        if (world.isBlockIndirectlyGettingPowered(i2, j2, k2)) {
            this.ignite(world, i2, j2, k2, true);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        if (l2 > 0 && Block.blocksList[l2].canProvidePower() && world.isBlockIndirectlyGettingPowered(i2, j2, k2)) {
            this.ignite(world, i2, j2, k2, true);
        }
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return 0;
    }

    @Override
    public void onBlockDestroyedByPlayer(World world, int i2, int j2, int k2, int l2) {
        if (!world.isMultiplayerAndNotHost) {
            world.dropItem(i2, j2, k2, new ItemStack(Block.tnt));
        }
    }

    @Override
    public void onBlockDestroyedByExplosion(World world, int i2, int j2, int k2) {
        EntityTNTPrimed entity = new EntityTNTPrimed(world, (float)i2 + 0.5f, (float)j2 + 0.5f, (float)k2 + 0.5f);
        entity.fuse = world.rand.nextInt(entity.fuse / 4) + entity.fuse / 8;
        world.entityJoinedWorld(entity);
    }

    public void ignite(World world, int x2, int y2, int z2, boolean sound) {
        this.ignite(world, x2, y2, z2, null, sound);
    }

    public void ignite(World world, int x2, int y2, int z2, EntityPlayer player, boolean sound) {
        if (world.isMultiplayerAndNotHost) {
            world.playSoundEffect((float)x2 + 0.5f, (float)y2 + 0.5f, (float)z2 + 0.5f, "random.fuse", 1.0f, 1.0f);
            if (player != null && player.inventory.getCurrentItem() != null && player.inventory.getCurrentItem().itemID == Item.toolFirestriker.itemID) {
                player.inventory.getCurrentItem().damageItem(1, player);
            }
            return;
        }
        world.setBlockWithNotify(x2, y2, z2, 0);
        EntityTNTPrimed e2 = new EntityTNTPrimed(world, (float)x2 + 0.5f, (float)y2 + 0.5f, (float)z2 + 0.5f);
        world.entityJoinedWorld(e2);
        world.playSoundAtEntity(e2, "random.fuse", 1.0f, 1.0f);
        if (player != null && player.inventory.getCurrentItem() != null && player.inventory.getCurrentItem().itemID == Item.toolFirestriker.itemID) {
            player.inventory.getCurrentItem().damageItem(1, player);
        }
    }

    @Override
    public void onBlockClicked(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        if (entityplayer.getCurrentEquippedItem() != null && entityplayer.getCurrentEquippedItem().itemID == Item.toolFirestriker.itemID) {
            world.setBlockMetadata(i2, j2, k2, 1);
        }
        super.onBlockClicked(world, i2, j2, k2, entityplayer);
    }

    @Override
    public boolean blockActivated(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        if (entityplayer.inventory.getCurrentItem() != null && entityplayer.inventory.getCurrentItem().itemID == Item.toolFirestriker.itemID) {
            this.ignite(world, i2, j2, k2, entityplayer, true);
            return true;
        }
        return super.blockActivated(world, i2, j2, k2, entityplayer);
    }
}

