/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFlower;
import net.minecraft.src.BlockMoss;
import net.minecraft.src.ColorizerGrass;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Season;
import net.minecraft.src.StatList;
import net.minecraft.src.World;

public class BlockTallGrass
extends BlockFlower {
    public BlockTallGrass(int i2) {
        super(i2);
        float f2 = 0.4f;
        this.setBlockBounds(0.5f - f2, 0.0f, 0.5f - f2, 0.5f + f2, 0.8f, 0.5f + f2);
    }

    @Override
    public void harvestBlock(World world, EntityPlayer entityplayer, int i2, int j2, int k2, int l2) {
        if (!world.isMultiplayerAndNotHost && entityplayer.getCurrentEquippedItem() != null && entityplayer.getCurrentEquippedItem().itemID == Item.toolShears.itemID) {
            entityplayer.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            world.dropItem(i2, j2, k2, new ItemStack(this.blockID, 1, 0));
        } else {
            super.harvestBlock(world, entityplayer, i2, j2, k2, l2);
        }
    }

    @Override
    public int getRenderColor(int i2) {
        return ColorizerGrass.getGrassColor(0.5, 0.5);
    }

    @Override
    public int colorMultiplier(World world, IBlockAccess iblockaccess, int i2, int j2, int k2) {
        Season season;
        long l1 = i2 * 3129871 + k2 * 6129781 + j2;
        l1 = l1 * l1 * 42317861L + l1 * 11L;
        i2 = (int)((long)i2 + (l1 >> 14 & 0x1FL));
        j2 = (int)((long)j2 + (l1 >> 19 & 0x1FL));
        k2 = (int)((long)k2 + (l1 >> 24 & 0x1FL));
        double localTemperature = iblockaccess.getWorldChunkManager().getTemperature(i2, k2);
        double localHumidity = iblockaccess.getWorldChunkManager().getHumidity(i2, k2);
        int baseGrassColor = ColorizerGrass.getGrassColor(localTemperature, localHumidity);
        if (world != null && (season = world.getCurrentSeason()) != null) {
            float progress = (float)world.dayInSeason / (float)(season.lengthTicks / Minecraft.DAY_LENGTH_TICKS);
            baseGrassColor = season.modifyGrassColorizer(baseGrassColor, progress > 0.5f ? world.getNextSeason() : world.getLastSeason(), Math.abs(progress - 0.5f));
        }
        return baseGrassColor;
    }

    @Override
    public int idDropped(int i2, Random random) {
        return -1;
    }

    @Override
    protected boolean canThisPlantGrowOnThisBlockID(int i2) {
        Block block = Block.getBlock(i2);
        if (block != null && block instanceof BlockMoss) {
            return true;
        }
        return super.canThisPlantGrowOnThisBlockID(i2);
    }
}

