/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Material;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import net.minecraft.src.helper.Direction;
import net.minecraft.src.helper.PlacementMode;

public class BlockTrapDoor
extends Block {
    public BlockTrapDoor(int i2, Material material) {
        super(i2, material);
        float f2 = 0.5f;
        float f1 = 1.0f;
        this.setBlockBounds(0.5f - f2, 0.0f, 0.5f - f2, 0.5f + f2, f1, 0.5f + f2);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 0;
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        this.setBlockBoundsBasedOnState(world, i2, j2, k2);
        return super.getSelectedBoundingBoxFromPool(world, i2, j2, k2);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        this.setBlockBoundsBasedOnState(world, i2, j2, k2);
        return super.getCollisionBoundingBoxFromPool(world, i2, j2, k2);
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int i2, int j2, int k2) {
        this.setBlockBoundsForBlockRender(world.getBlockMetadata(i2, j2, k2));
    }

    @Override
    public void setBlockBoundsForItemRender() {
        float f2 = 0.1875f;
        this.setBlockBounds(0.0f, 0.5f - f2 / 2.0f, 0.0f, 1.0f, 0.5f + f2 / 2.0f, 1.0f);
    }

    public void setBlockBoundsForBlockRender(int i2) {
        float f2 = 0.1875f;
        if (BlockTrapDoor.isTrapdoorOpen(i2)) {
            if ((i2 & 3) == 0) {
                this.setBlockBounds(0.0f, 0.0f, 1.0f - f2, 1.0f, 1.0f, 1.0f);
            }
            if ((i2 & 3) == 1) {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f2);
            }
            if ((i2 & 3) == 2) {
                this.setBlockBounds(1.0f - f2, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
            if ((i2 & 3) == 3) {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, f2, 1.0f, 1.0f);
            }
        } else if (BlockTrapDoor.isUpperHalf(i2)) {
            this.setBlockBounds(0.0f, 1.0f - f2, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, f2, 1.0f);
        }
    }

    @Override
    public boolean blockActivated(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        if (this.blockMaterial != Material.iron) {
            int l2 = world.getBlockMetadata(i2, j2, k2);
            world.setBlockMetadataWithNotify(i2, j2, k2, l2 ^ 4);
            world.playSoundEffectForPlayer(entityplayer, 1003, i2, j2, k2, 0);
            return true;
        }
        return false;
    }

    public void onPoweredBlockChange(World world, int i2, int j2, int k2, boolean flag) {
        boolean flag1;
        int l2 = world.getBlockMetadata(i2, j2, k2);
        boolean bl2 = flag1 = (l2 & 4) > 0;
        if (flag1 != flag) {
            world.setBlockMetadataWithNotify(i2, j2, k2, l2 ^ 4);
            world.playSoundEffectForPlayer(null, 1003, i2, j2, k2, 0);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        if (l2 > 0 && Block.blocksList[l2].canProvidePower()) {
            boolean flag = world.isBlockIndirectlyGettingPowered(i2, j2, k2);
            this.onPoweredBlockChange(world, i2, j2, k2, flag);
        }
    }

    @Override
    public MovingObjectPosition collisionRayTrace(World world, int i2, int j2, int k2, Vec3D vec3d, Vec3D vec3d1) {
        this.setBlockBoundsBasedOnState(world, i2, j2, k2);
        return super.collisionRayTrace(world, i2, j2, k2, vec3d, vec3d1);
    }

    @Override
    public void onBlockPlaced(World world, int x2, int y2, int z2, Direction side, EntityLiving player, double sideHeight) {
        int meta = Direction.getLegacySide2(player.getHorizontalPlacementDirection(side, PlacementMode.SIDE).getOpposite());
        if (player.getVerticalPlacementDirection(side, sideHeight) == Direction.UP) {
            meta |= 8;
        }
        world.setBlockMetadata(x2, y2, z2, meta);
    }

    public static boolean isTrapdoorOpen(int i2) {
        return (i2 & 4) != 0;
    }

    public static boolean isUpperHalf(int meta) {
        return (meta & 8) != 0;
    }
}

