/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainerRotatable;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityTrommel;
import net.minecraft.src.World;

public class BlockTrommel
extends BlockContainerRotatable {
    private boolean isActive;
    protected static boolean keepTrommelInventory = false;
    private Random random;

    public BlockTrommel(int i2, Material material, boolean isActive) {
        super(i2, material);
        this.isActive = isActive;
        this.random = new Random();
    }

    @Override
    public void onBlockAdded(World world, int i2, int j2, int k2) {
        super.onBlockAdded(world, i2, j2, k2);
        this.setDefaultDirection(world, i2, j2, k2);
    }

    @Override
    public boolean blockActivated(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        if (!world.isMultiplayerAndNotHost) {
            TileEntityTrommel tileEntityTrommel = (TileEntityTrommel)world.getBlockTileEntity(i2, j2, k2);
            entityplayer.displayGUITrommel(tileEntityTrommel);
        }
        return true;
    }

    @Override
    public void randomDisplayTick(World world, int i2, int j2, int k2, Random random) {
        if (!this.isActive) {
            return;
        }
        float f2 = (float)i2 + random.nextFloat();
        float f6 = (float)j2 + random.nextFloat() * 0.5f + 1.0f;
        float f12 = (float)k2 + random.nextFloat();
        world.spawnParticle("smoke", f2, f6, f12, 0.0, 0.0, 0.0);
    }

    public static void updateTrommelBlockState(boolean flag, World world, int i2, int j2, int k2) {
        int l2 = world.getBlockMetadata(i2, j2, k2);
        TileEntity tileentity = world.getBlockTileEntity(i2, j2, k2);
        keepTrommelInventory = true;
        if (flag) {
            world.setBlockWithNotify(i2, j2, k2, Block.trommelActive.blockID);
        } else {
            world.setBlockWithNotify(i2, j2, k2, Block.trommelIdle.blockID);
        }
        keepTrommelInventory = false;
        world.setBlockMetadataWithNotify(i2, j2, k2, l2);
        tileentity.validate();
        world.setBlockTileEntity(i2, j2, k2, tileentity);
    }

    @Override
    public int idDropped(int i2, Random random) {
        return Block.trommelIdle.blockID;
    }

    @Override
    public void onBlockRemoval(World world, int i2, int j2, int k2) {
        if (!keepTrommelInventory && world.getBlockTileEntity(i2, j2, k2) != null) {
            TileEntityTrommel tileentitytrommel = (TileEntityTrommel)world.getBlockTileEntity(i2, j2, k2);
            for (int l2 = 0; l2 < tileentitytrommel.getSizeInventory(); ++l2) {
                ItemStack itemstack = tileentitytrommel.getStackInSlot(l2);
                if (itemstack == null) continue;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                float f22 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int i1 = this.random.nextInt(21) + 10;
                    if (i1 > itemstack.stackSize) {
                        i1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= i1;
                    EntityItem entityitem = new EntityItem(world, (float)i2 + f2, (float)j2 + f1, (float)k2 + f22, new ItemStack(itemstack.itemID, i1, itemstack.getMetadata()));
                    float f3 = 0.05f;
                    entityitem.motionX = (float)this.random.nextGaussian() * f3;
                    entityitem.motionY = (float)this.random.nextGaussian() * f3 + 0.2f;
                    entityitem.motionZ = (float)this.random.nextGaussian() * f3;
                    world.entityJoinedWorld(entityitem);
                }
            }
        }
        super.onBlockRemoval(world, i2, j2, k2);
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntityTrommel();
    }
}

