/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.ChunkBlockMap;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.Entity;
import net.minecraft.src.EnumLightType;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NibbleArray;
import net.minecraft.src.NibbleArrayExtended;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;

public class Chunk {
    public static boolean isLit;
    public short[] blocks;
    public boolean isChunkLoaded;
    public World worldObj;
    public NibbleArrayExtended data;
    public NibbleArray skylightMap;
    public NibbleArray blocklightMap;
    public byte[] heightMap;
    public int lowestBlockHeight;
    public final int xPosition;
    public final int zPosition;
    public Map chunkTileEntityMap = new HashMap();
    public List[] entities = new List[Minecraft.WORLD_HEIGHT_BLOCKS / 16];
    public double[] temperature;
    public double[] humidity;
    public byte[] biome;
    public boolean isTerrainPopulated = false;
    public boolean isModified = false;
    public boolean neverSave;
    public boolean hasEntities = false;
    public long lastSaveTime = 0L;
    public boolean receivedFromServer = false;
    public long ticksUnreceived = 0L;

    public Chunk(World world, int i2, int j2) {
        this.worldObj = world;
        this.xPosition = i2;
        this.zPosition = j2;
        this.heightMap = new byte[256];
        this.biome = new byte[256];
        this.temperature = new double[256];
        this.humidity = new double[256];
        for (int k2 = 0; k2 < this.entities.length; ++k2) {
            this.entities[k2] = new ArrayList();
        }
    }

    public Chunk(World world, short[] ashort0, int i2, int j2) {
        this(world, i2, j2);
        if (ashort0.length < 256 * Minecraft.WORLD_HEIGHT_BLOCKS) {
            this.blocks = new short[256 * Minecraft.WORLD_HEIGHT_BLOCKS];
            System.arraycopy(ashort0, 0, this.blocks, 0, ashort0.length);
        } else {
            this.blocks = ashort0;
        }
        this.data = new NibbleArrayExtended(ashort0.length);
        this.skylightMap = new NibbleArray(ashort0.length);
        this.blocklightMap = new NibbleArray(ashort0.length);
        Arrays.fill(this.temperature, Double.NEGATIVE_INFINITY);
        Arrays.fill(this.humidity, Double.NEGATIVE_INFINITY);
        Arrays.fill(this.biome, (byte)-1);
    }

    public boolean isAtLocation(int i2, int j2) {
        return i2 == this.xPosition && j2 == this.zPosition;
    }

    public int getHeightValue(int i2, int j2) {
        return Byte.toUnsignedInt(this.heightMap[j2 << 4 | i2]);
    }

    public void func_1014_a() {
    }

    public void generateHeightMap() {
        int i2 = Minecraft.WORLD_HEIGHT_BLOCKS - 1;
        for (int j2 = 0; j2 < 16; ++j2) {
            for (int k2 = 0; k2 < 16; ++k2) {
                int l2;
                int i1 = j2 << Minecraft.WORLD_HEIGHT_BITS + 4 | k2 << Minecraft.WORLD_HEIGHT_BITS;
                for (l2 = Minecraft.WORLD_HEIGHT_BLOCKS - 1; l2 > 0 && Block.lightOpacity[this.blocks[i1 + l2 - 1] & 0x3FFF] == 0; --l2) {
                }
                this.heightMap[k2 << 4 | j2] = (byte)l2;
                if (l2 >= i2) continue;
                i2 = l2;
            }
        }
        this.lowestBlockHeight = i2;
        this.isModified = true;
    }

    public void func_1024_c() {
        int i2 = Minecraft.WORLD_HEIGHT_BLOCKS - 1;
        for (int j2 = 0; j2 < 16; ++j2) {
            for (int l2 = 0; l2 < 16; ++l2) {
                int j1;
                int k1 = j2 << Minecraft.WORLD_HEIGHT_BITS + 4 | l2 << Minecraft.WORLD_HEIGHT_BITS;
                for (j1 = Minecraft.WORLD_HEIGHT_BLOCKS - 1; j1 > 0 && Block.lightOpacity[this.blocks[k1 + j1 - 1] & 0x3FFF] == 0; --j1) {
                }
                this.heightMap[l2 << 4 | j2] = (byte)j1;
                if (j1 < i2) {
                    i2 = j1;
                }
                if (this.worldObj.dimension.worldType.worldProvider.hasNoSky) continue;
                int l1 = 15;
                int i22 = Minecraft.WORLD_HEIGHT_BLOCKS - 1;
                do {
                    if ((l1 -= Block.lightOpacity[this.blocks[k1 + i22] & 0x3FFF]) <= 0) continue;
                    this.skylightMap.setNibble(j2, i22, l2, l1);
                } while (--i22 > 0 && l1 > 0);
            }
        }
        this.lowestBlockHeight = i2;
        for (int k2 = 0; k2 < 16; ++k2) {
            for (int i1 = 0; i1 < 16; ++i1) {
                this.func_996_c(k2, i1);
            }
        }
        this.isModified = true;
    }

    public void func_4143_d() {
    }

    private void func_996_c(int i2, int j2) {
        int k2 = this.getHeightValue(i2, j2);
        int l2 = this.xPosition * 16 + i2;
        int i1 = this.zPosition * 16 + j2;
        this.func_1020_f(l2 - 1, i1, k2);
        this.func_1020_f(l2 + 1, i1, k2);
        this.func_1020_f(l2, i1 - 1, k2);
        this.func_1020_f(l2, i1 + 1, k2);
    }

    private void func_1020_f(int i2, int j2, int k2) {
        int l2 = this.worldObj.getHeightValue(i2, j2);
        if (l2 > k2) {
            this.worldObj.scheduleLightingUpdate(EnumLightType.Sky, i2, k2, j2, i2, l2, j2);
            this.isModified = true;
        } else if (l2 < k2) {
            this.worldObj.scheduleLightingUpdate(EnumLightType.Sky, i2, l2, j2, i2, k2, j2);
            this.isModified = true;
        }
    }

    private void func_1003_g(int i2, int j2, int k2) {
        int l2;
        int i1 = l2 = this.heightMap[k2 << 4 | i2] & 0xFF;
        if (j2 > l2) {
            i1 = j2;
        }
        int j1 = i2 << Minecraft.WORLD_HEIGHT_BITS + 4 | k2 << Minecraft.WORLD_HEIGHT_BITS;
        while (i1 > 0 && Block.lightOpacity[this.blocks[j1 + i1 - 1] & 0x3FFF] == 0) {
            --i1;
        }
        if (i1 == l2) {
            return;
        }
        this.worldObj.markBlocksDirtyVertical(i2, k2, i1, l2);
        this.heightMap[k2 << 4 | i2] = (byte)i1;
        if (i1 < this.lowestBlockHeight) {
            this.lowestBlockHeight = i1;
        } else {
            int k1 = Minecraft.WORLD_HEIGHT_BLOCKS - 1;
            for (int i22 = 0; i22 < 16; ++i22) {
                for (int k22 = 0; k22 < 16; ++k22) {
                    if ((this.heightMap[k22 << 4 | i22] & 0xFF) >= k1) continue;
                    k1 = this.heightMap[k22 << 4 | i22] & 0xFF;
                }
            }
            this.lowestBlockHeight = k1;
        }
        int l1 = this.xPosition * 16 + i2;
        int j22 = this.zPosition * 16 + k2;
        if (i1 < l2) {
            for (int l22 = i1; l22 < l2; ++l22) {
                this.skylightMap.setNibble(i2, l22, k2, 15);
            }
        } else {
            this.worldObj.scheduleLightingUpdate(EnumLightType.Sky, l1, l2, j22, l1, i1, j22);
            for (int i3 = l2; i3 < i1; ++i3) {
                this.skylightMap.setNibble(i2, i3, k2, 0);
            }
        }
        int j3 = 15;
        int k3 = i1;
        while (i1 > 0 && j3 > 0) {
            int l3;
            if ((l3 = Block.lightOpacity[this.getBlockID(i2, --i1, k2)]) == 0) {
                l3 = 1;
            }
            if ((j3 -= l3) < 0) {
                j3 = 0;
            }
            this.skylightMap.setNibble(i2, i1, k2, j3);
        }
        while (i1 > 0 && Block.lightOpacity[this.getBlockID(i2, i1 - 1, k2)] == 0) {
            --i1;
        }
        if (i1 != k3) {
            this.worldObj.scheduleLightingUpdate(EnumLightType.Sky, l1 - 1, i1, j22 - 1, l1 + 1, k3, j22 + 1);
        }
        this.isModified = true;
    }

    public int getBlockID(int i2, int j2, int k2) {
        return this.blocks[i2 << Minecraft.WORLD_HEIGHT_BITS + 4 | k2 << Minecraft.WORLD_HEIGHT_BITS | j2] & 0x3FFF;
    }

    public boolean setBlockIDWithMetadata(int i2, int j2, int k2, int l2, int i1) {
        short short0 = (short)l2;
        int j1 = this.heightMap[k2 << 4 | i2] & 0xFF;
        int k1 = this.blocks[i2 << Minecraft.WORLD_HEIGHT_BITS + 4 | k2 << Minecraft.WORLD_HEIGHT_BITS | j2] & 0x3FFF;
        if (k1 == l2 && this.data.getNibble(i2, j2, k2) == i1) {
            return false;
        }
        int l1 = this.xPosition * 16 + i2;
        int i22 = this.zPosition * 16 + k2;
        this.blocks[i2 << Minecraft.WORLD_HEIGHT_BITS + 4 | k2 << Minecraft.WORLD_HEIGHT_BITS | j2] = (short)(short0 & 0x3FFF);
        if (k1 != 0 && !this.worldObj.isMultiplayerAndNotHost) {
            Block.blocksList[k1].onBlockRemoval(this.worldObj, l1, j2, i22);
        }
        this.data.setNibble(i2, j2, k2, i1);
        if (!this.worldObj.dimension.worldType.worldProvider.hasNoSky) {
            if (Block.lightOpacity[short0 & 0x3FFF] != 0) {
                if (j2 >= j1) {
                    this.func_1003_g(i2, j2 + 1, k2);
                }
            } else if (j2 == j1 - 1) {
                this.func_1003_g(i2, j2, k2);
            }
            this.worldObj.scheduleLightingUpdate(EnumLightType.Sky, l1, j2, i22, l1, j2, i22);
        }
        this.worldObj.scheduleLightingUpdate(EnumLightType.Block, l1, j2, i22, l1, j2, i22);
        this.func_996_c(i2, k2);
        this.data.setNibble(i2, j2, k2, i1);
        if (l2 != 0) {
            Block.blocksList[l2].onBlockAdded(this.worldObj, l1, j2, i22);
        }
        this.isModified = true;
        return true;
    }

    public boolean setBlockID(int i2, int j2, int k2, int l2) {
        short short0 = (short)l2;
        int i1 = this.heightMap[k2 << 4 | i2] & 0xFF;
        int j1 = this.blocks[i2 << Minecraft.WORLD_HEIGHT_BITS + 4 | k2 << Minecraft.WORLD_HEIGHT_BITS | j2] & 0x3FFF;
        if (j1 == l2) {
            return false;
        }
        int k1 = this.xPosition * 16 + i2;
        int l1 = this.zPosition * 16 + k2;
        this.blocks[i2 << Minecraft.WORLD_HEIGHT_BITS + 4 | k2 << Minecraft.WORLD_HEIGHT_BITS | j2] = (short)(short0 & 0x3FFF);
        if (j1 != 0) {
            Block.blocksList[j1].onBlockRemoval(this.worldObj, k1, j2, l1);
        }
        this.data.setNibble(i2, j2, k2, 0);
        if (Block.lightOpacity[short0 & 0x3FFF] != 0) {
            if (j2 >= i1) {
                this.func_1003_g(i2, j2 + 1, k2);
            }
        } else if (j2 == i1 - 1) {
            this.func_1003_g(i2, j2, k2);
        }
        this.worldObj.scheduleLightingUpdate(EnumLightType.Sky, k1, j2, l1, k1, j2, l1);
        this.worldObj.scheduleLightingUpdate(EnumLightType.Block, k1, j2, l1, k1, j2, l1);
        this.func_996_c(i2, k2);
        if (l2 != 0 && !this.worldObj.isMultiplayerAndNotHost) {
            Block.blocksList[l2].onBlockAdded(this.worldObj, k1, j2, l1);
        }
        this.isModified = true;
        return true;
    }

    public boolean setBlockIDRaw(int i2, int j2, int k2, int l2) {
        short short0 = (short)l2;
        int j1 = this.blocks[i2 << Minecraft.WORLD_HEIGHT_BITS + 4 | k2 << Minecraft.WORLD_HEIGHT_BITS | j2] & 0x3FFF;
        if (j1 == l2) {
            return false;
        }
        int k1 = this.xPosition * 16 + i2;
        int l1 = this.zPosition * 16 + k2;
        this.blocks[i2 << Minecraft.WORLD_HEIGHT_BITS + 4 | k2 << Minecraft.WORLD_HEIGHT_BITS | j2] = (short)(short0 & 0x3FFF);
        this.data.setNibble(i2, j2, k2, 0);
        this.worldObj.scheduleLightingUpdate(EnumLightType.Block, k1, j2, l1, k1, j2, l1);
        this.func_996_c(i2, k2);
        this.isModified = true;
        return true;
    }

    public int getBlockMetadata(int i2, int j2, int k2) {
        return this.data.getNibble(i2, j2, k2);
    }

    public void setBlockMetadata(int i2, int j2, int k2, int l2) {
        this.isModified = true;
        this.data.setNibble(i2, j2, k2, l2);
    }

    public BiomeGenBase getBlockBiome(int x2, int z2) {
        byte b2 = this.biome[x2 * 16 + z2];
        if (b2 == -1) {
            return null;
        }
        return BiomeGenBase.biomeList[b2];
    }

    public boolean setBlockBiome(int x2, int z2, BiomeGenBase biome) {
        byte presentBiome = this.biome[x2 * 16 + z2];
        if (presentBiome == biome.id) {
            return false;
        }
        this.biome[x2 * 16 + z2] = (byte)biome.id;
        return true;
    }

    public double getBlockTemperature(int x2, int z2) {
        return this.temperature[x2 * 16 + z2];
    }

    public boolean setBlockTemperature(int x2, int z2, double temperature) {
        double presentTemperature = this.temperature[x2 * 16 + z2];
        if (presentTemperature == temperature) {
            return false;
        }
        this.temperature[x2 * 16 + z2] = temperature;
        return true;
    }

    public double getBlockHumidity(int x2, int z2) {
        return this.humidity[x2 * 16 + z2];
    }

    public boolean setBlockHumidity(int x2, int z2, double humidity) {
        double presentHumidity = this.humidity[x2 * 16 + z2];
        if (presentHumidity == humidity) {
            return false;
        }
        this.humidity[x2 * 16 + z2] = humidity;
        return true;
    }

    public int getSavedLightValue(EnumLightType enumskyblock, int i2, int j2, int k2) {
        if (enumskyblock == EnumLightType.Sky) {
            return this.skylightMap.getNibble(i2, j2, k2);
        }
        if (enumskyblock == EnumLightType.Block) {
            return this.blocklightMap.getNibble(i2, j2, k2);
        }
        return 0;
    }

    public void setLightValue(EnumLightType enumskyblock, int i2, int j2, int k2, int l2) {
        this.isModified = true;
        if (enumskyblock == EnumLightType.Sky) {
            this.skylightMap.setNibble(i2, j2, k2, l2);
        } else if (enumskyblock == EnumLightType.Block) {
            this.blocklightMap.setNibble(i2, j2, k2, l2);
        } else {
            return;
        }
    }

    public int getBlockLightValue(int i2, int j2, int k2, int l2) {
        int j1;
        int i1 = this.skylightMap.getNibble(i2, j2, k2);
        if (i1 > 0) {
            isLit = true;
        }
        if ((j1 = this.blocklightMap.getNibble(i2, j2, k2)) > (i1 -= l2)) {
            i1 = j1;
        }
        return i1;
    }

    public void addEntity(Entity entity) {
        int k2;
        this.hasEntities = true;
        int i2 = MathHelper.floor_double(entity.posX / 16.0);
        int j2 = MathHelper.floor_double(entity.posZ / 16.0);
        if (i2 != this.xPosition || j2 != this.zPosition) {
            System.out.println("Wrong location! " + entity);
            Thread.dumpStack();
        }
        if ((k2 = MathHelper.floor_double(entity.posY / 16.0)) < 0) {
            k2 = 0;
        }
        if (k2 >= this.entities.length) {
            k2 = this.entities.length - 1;
        }
        entity.addedToChunk = true;
        entity.chunkCoordX = this.xPosition;
        entity.chunkCoordY = k2;
        entity.chunkCoordZ = this.zPosition;
        this.entities[k2].add(entity);
    }

    public void removeEntity(Entity entity) {
        this.removeEntityAtIndex(entity, entity.chunkCoordY);
    }

    public void removeEntityAtIndex(Entity entity, int i2) {
        if (i2 < 0) {
            i2 = 0;
        }
        if (i2 >= this.entities.length) {
            i2 = this.entities.length - 1;
        }
        this.entities[i2].remove(entity);
    }

    public boolean canBlockSeeTheSky(int i2, int j2, int k2) {
        return j2 >= (this.heightMap[k2 << 4 | i2] & 0xFF);
    }

    public TileEntity getChunkBlockTileEntity(int i2, int j2, int k2) {
        ChunkPosition chunkposition = new ChunkPosition(i2, j2, k2);
        TileEntity tileentity = (TileEntity)this.chunkTileEntityMap.get(chunkposition);
        if (tileentity == null) {
            int l2 = this.getBlockID(i2, j2, k2);
            if (!Block.isBlockContainer[l2]) {
                return null;
            }
            BlockContainer blockcontainer = (BlockContainer)Block.blocksList[l2];
            blockcontainer.onBlockAdded(this.worldObj, this.xPosition * 16 + i2, j2, this.zPosition * 16 + k2);
            tileentity = (TileEntity)this.chunkTileEntityMap.get(chunkposition);
        }
        if (tileentity != null && tileentity.isInvalid()) {
            this.chunkTileEntityMap.remove(chunkposition);
            return null;
        }
        return tileentity;
    }

    public void addTileEntity(TileEntity tileentity) {
        int i2 = tileentity.xCoord - this.xPosition * 16;
        int j2 = tileentity.yCoord;
        int k2 = tileentity.zCoord - this.zPosition * 16;
        this.setChunkBlockTileEntity(i2, j2, k2, tileentity);
        if (this.isChunkLoaded) {
            this.worldObj.loadedTileEntityList.add(tileentity);
        }
    }

    public void setChunkBlockTileEntity(int i2, int j2, int k2, TileEntity tileentity) {
        ChunkPosition chunkposition = new ChunkPosition(i2, j2, k2);
        tileentity.worldObj = this.worldObj;
        tileentity.xCoord = this.xPosition * 16 + i2;
        tileentity.yCoord = j2;
        tileentity.zCoord = this.zPosition * 16 + k2;
        if (this.getBlockID(i2, j2, k2) == 0 || !(Block.blocksList[this.getBlockID(i2, j2, k2)] instanceof BlockContainer)) {
            System.out.println("Attempted to place a tile entity where there was no entity tile!");
            return;
        }
        tileentity.validate();
        this.chunkTileEntityMap.put(chunkposition, tileentity);
    }

    public void removeChunkBlockTileEntity(int i2, int j2, int k2) {
        TileEntity tileentity;
        ChunkPosition chunkposition = new ChunkPosition(i2, j2, k2);
        if (this.isChunkLoaded && (tileentity = (TileEntity)this.chunkTileEntityMap.remove(chunkposition)) != null) {
            tileentity.invalidate();
        }
    }

    public void onChunkLoad() {
        this.isChunkLoaded = true;
        this.worldObj.func_31054_a(this.chunkTileEntityMap.values());
        for (int i2 = 0; i2 < this.entities.length; ++i2) {
            this.worldObj.addLoadedEntities(this.entities[i2]);
        }
    }

    public void onChunkUnload() {
        this.isChunkLoaded = false;
        for (TileEntity tileentity : this.chunkTileEntityMap.values()) {
            tileentity.invalidate();
        }
        for (int i2 = 0; i2 < this.entities.length; ++i2) {
            this.worldObj.unloadEntities(this.entities[i2]);
        }
    }

    public void setChunkModified() {
        this.isModified = true;
    }

    public void getEntitiesWithinAABBForEntity(Entity entity, AxisAlignedBB axisalignedbb, List list) {
        int i2 = MathHelper.floor_double((axisalignedbb.minY - 2.0) / 16.0);
        int j2 = MathHelper.floor_double((axisalignedbb.maxY + 2.0) / 16.0);
        if (i2 < 0) {
            i2 = 0;
        }
        if (j2 >= this.entities.length) {
            j2 = this.entities.length - 1;
        }
        for (int k2 = i2; k2 <= j2; ++k2) {
            List list1 = this.entities[k2];
            for (int l2 = 0; l2 < list1.size(); ++l2) {
                Entity entity1 = (Entity)list1.get(l2);
                if (entity1 == entity || !entity1.boundingBox.intersectsWith(axisalignedbb)) continue;
                list.add(entity1);
            }
        }
    }

    public void getEntitiesOfTypeWithinAAAB(Class class1, AxisAlignedBB axisalignedbb, List list) {
        int i2 = MathHelper.floor_double((axisalignedbb.minY - 2.0) / 16.0);
        int j2 = MathHelper.floor_double((axisalignedbb.maxY + 2.0) / 16.0);
        if (i2 < 0) {
            i2 = 0;
        }
        if (j2 >= this.entities.length) {
            j2 = this.entities.length - 1;
        }
        for (int k2 = i2; k2 <= j2; ++k2) {
            List list1 = this.entities[k2];
            for (int l2 = 0; l2 < list1.size(); ++l2) {
                Entity entity = (Entity)list1.get(l2);
                if (!class1.isAssignableFrom(entity.getClass()) || !entity.boundingBox.intersectsWith(axisalignedbb)) continue;
                list.add(entity);
            }
        }
    }

    public boolean needsSaving(boolean flag) {
        if (this.neverSave) {
            return false;
        }
        if (flag ? this.hasEntities && this.worldObj.getWorldTime() != this.lastSaveTime : this.hasEntities && this.worldObj.getWorldTime() >= this.lastSaveTime + 600L) {
            return true;
        }
        return this.isModified;
    }

    public int setChunkData(byte[] abyte0, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int startIndex) {
        ByteBuffer bb2 = ByteBuffer.allocate(this.blocks.length * 2);
        bb2.asShortBuffer().put(this.blocks);
        if (abyte0.length > 65536) {
            this.receivedFromServer = true;
        }
        for (int cX = minX; cX < maxX; ++cX) {
            for (int cZ = minZ; cZ < maxZ; ++cZ) {
                int cIndex = cX << Minecraft.WORLD_HEIGHT_BITS + 4 | cZ << Minecraft.WORLD_HEIGHT_BITS | minY;
                int cY = maxY - minY;
                System.arraycopy(abyte0, startIndex, bb2.array(), cIndex * 2, cY * 2);
                startIndex += cY * 2;
            }
        }
        ShortBuffer.wrap(this.blocks).put(bb2.asShortBuffer());
        this.generateHeightMap();
        for (int i2 = minX; i2 < maxX; ++i2) {
            for (int i3 = minZ; i3 < maxZ; ++i3) {
                int i4 = i2 << Minecraft.WORLD_HEIGHT_BITS + 4 | i3 << Minecraft.WORLD_HEIGHT_BITS | minY;
                int i5 = maxY - minY;
                System.arraycopy(abyte0, startIndex, this.data.data, i4, i5);
                startIndex += i5;
            }
        }
        for (int j2 = minX; j2 < maxX; ++j2) {
            for (int j3 = minZ; j3 < maxZ; ++j3) {
                int j4 = (j2 << Minecraft.WORLD_HEIGHT_BITS + 4 | j3 << Minecraft.WORLD_HEIGHT_BITS | minY) >> 1;
                int j5 = (maxY - minY) / 2;
                System.arraycopy(abyte0, startIndex, this.blocklightMap.data, j4, j5);
                startIndex += j5;
            }
        }
        for (int k2 = minX; k2 < maxX; ++k2) {
            for (int k3 = minZ; k3 < maxZ; ++k3) {
                int k4 = (k2 << Minecraft.WORLD_HEIGHT_BITS + 4 | k3 << Minecraft.WORLD_HEIGHT_BITS | minY) >> 1;
                int k5 = (maxY - minY) / 2;
                System.arraycopy(abyte0, startIndex, this.skylightMap.data, k4, k5);
                startIndex += k5;
            }
        }
        return startIndex;
    }

    public int getChunkData(byte[] abyte0, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int startIndex) {
        int width = maxX - minX;
        int height = maxY - minY;
        int length = maxZ - minZ;
        ByteBuffer bb2 = ByteBuffer.allocate(this.blocks.length * 2);
        bb2.asShortBuffer().put(this.blocks);
        if (width * height * length == this.blocks.length) {
            System.arraycopy(bb2.array(), 0, abyte0, startIndex, this.blocks.length * 2);
            System.arraycopy(this.data.data, 0, abyte0, startIndex += this.blocks.length * 2, this.data.data.length);
            System.arraycopy(this.blocklightMap.data, 0, abyte0, startIndex += this.data.data.length, this.blocklightMap.data.length);
            System.arraycopy(this.skylightMap.data, 0, abyte0, startIndex += this.blocklightMap.data.length, this.skylightMap.data.length);
            return startIndex += this.skylightMap.data.length;
        }
        for (int cX = minX; cX < maxX; ++cX) {
            for (int cZ = minZ; cZ < maxZ; ++cZ) {
                int cIndex = cX << Minecraft.WORLD_HEIGHT_BITS + 4 | cZ << Minecraft.WORLD_HEIGHT_BITS | minY;
                System.arraycopy(bb2.array(), cIndex * 2, abyte0, startIndex, height * 2);
                startIndex += height * 2;
            }
        }
        for (int l2 = minX; l2 < maxX; ++l2) {
            for (int l3 = minZ; l3 < maxZ; ++l3) {
                int l4 = l2 << Minecraft.WORLD_HEIGHT_BITS + 4 | l3 << Minecraft.WORLD_HEIGHT_BITS | minY;
                System.arraycopy(this.data.data, l4, abyte0, startIndex, height);
                startIndex += height;
            }
        }
        for (int i3 = minX; i3 < maxX; ++i3) {
            for (int i4 = minZ; i4 < maxZ; ++i4) {
                int i5 = (i3 << Minecraft.WORLD_HEIGHT_BITS + 4 | i4 << Minecraft.WORLD_HEIGHT_BITS | minY) >> 1;
                int i6 = height / 2;
                System.arraycopy(this.blocklightMap.data, i5, abyte0, startIndex, i6);
                startIndex += i6;
            }
        }
        for (int j3 = minX; j3 < maxX; ++j3) {
            for (int j4 = minZ; j4 < maxZ; ++j4) {
                int j5 = (j3 << Minecraft.WORLD_HEIGHT_BITS + 4 | j4 << Minecraft.WORLD_HEIGHT_BITS | minY) >> 1;
                int j6 = height / 2;
                System.arraycopy(this.skylightMap.data, j5, abyte0, startIndex, j6);
                startIndex += j6;
            }
        }
        return startIndex;
    }

    public Random func_997_a(long l2) {
        return new Random(this.worldObj.getRandomSeed() + (long)(this.xPosition * this.xPosition * 4987142) + (long)(this.xPosition * 5947611) + (long)(this.zPosition * this.zPosition) * 4392871L + (long)(this.zPosition * 389711) ^ l2);
    }

    public boolean func_21167_h() {
        return false;
    }

    public void func_25124_i() {
        ChunkBlockMap.func_26002_a(this.blocks);
    }
}

